/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.validation;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.CheckParametersExpressionContainer;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.executions.QueryExecutionsErrorCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class CheckParametersExpressionContainerValidator
implements ConstraintValidator<CheckParametersExpressionContainer, Map<String, ClientExpressionContainer>>,
ValidationErrorDescriptorBuilder {
    private Set<Class> acceptedExpressions;

    public void initialize(CheckParametersExpressionContainer constraintAnnotation) {
        this.acceptedExpressions = new HashSet<Class<? extends ClientExpression>>(Arrays.asList(constraintAnnotation.value()));
    }

    public boolean isValid(Map<String, ClientExpressionContainer> expressionMap, ConstraintValidatorContext context) {
        if (expressionMap == null) {
            return true;
        }
        for (Map.Entry<String, ClientExpressionContainer> entry : expressionMap.entrySet()) {
            ClientExpression expression;
            ClientExpressionContainer expressionContainer = entry.getValue();
            if (expressionContainer == null) {
                return false;
            }
            if (expressionContainer.getString() != null || (expression = expressionContainer.getObject()) != null && this.acceptedExpressions.contains(expression.getClass())) continue;
            return false;
        }
        return true;
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        return QueryExecutionsErrorCode.QUERY_WHERE_PARAMETERS_EXPRESSION_NOT_VALID.createDescriptor(new Object[0]);
    }
}

