/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.validation;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpression;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.InstanceOf;
import com.jaspersoft.jasperserver.dto.common.ClientTypeUtility;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class InstanceOfValidator
implements ConstraintValidator<InstanceOf, ClientExpression>,
ValidationErrorDescriptorBuilder {
    protected Set<Class> acceptedClasses = new HashSet<Class>();

    public void initialize(InstanceOf constraintAnnotation) {
        this.acceptedClasses = new HashSet(Arrays.asList(constraintAnnotation.value()));
    }

    public boolean isValid(ClientExpression value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (this.acceptedClasses != null && !this.acceptedClasses.isEmpty()) {
            for (Class clazz : this.acceptedClasses) {
                if (!clazz.isInstance(value)) continue;
                return true;
            }
        }
        return false;
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        InstanceOf annotation = (InstanceOf)violation.getConstraintDescriptor().getAnnotation();
        ErrorDescriptor errorDescriptor = new ErrorDescriptor().setErrorCode(annotation.errorCode()).setMessage(annotation.message());
        errorDescriptor.addProperties(new ClientProperty("invalidType", ClientTypeUtility.extractClientType(violation.getInvalidValue().getClass())));
        return errorDescriptor;
    }
}

