/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.validation;

import com.jaspersoft.jasperserver.dto.adhoc.query.el.ClientExpressionContainer;
import com.jaspersoft.jasperserver.dto.adhoc.query.validation.ParameterMap;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.executions.QueryExecutionsErrorCode;
import java.util.Map;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class ParameterMapValidator
implements ConstraintValidator<ParameterMap, Map<String, ClientExpressionContainer>>,
ValidationErrorDescriptorBuilder {
    public static Pattern NOT_W_PATTERN = Pattern.compile("[^\\p{L}\\p{N}_]");
    public static Pattern NOT_A_TO_Z_OR_UNDERSCORE_PATTERN = Pattern.compile("[^\\p{L}_]");

    public void initialize(ParameterMap constraintAnnotation) {
    }

    public boolean isValid(Map<String, ClientExpressionContainer> targetParameterMap, ConstraintValidatorContext context) {
        if (targetParameterMap != null) {
            for (String paramEl : targetParameterMap.keySet()) {
                if (paramEl != null && !paramEl.contains(".") && !NOT_A_TO_Z_OR_UNDERSCORE_PATTERN.matcher(paramEl.substring(0, 1)).matches() && !NOT_W_PATTERN.matcher(paramEl).find()) continue;
                return false;
            }
        }
        return true;
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        return QueryExecutionsErrorCode.PARAMETER_NAME_IN_NOT_VALID.createDescriptor(new Object[0]);
    }
}

