/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.adhoc.query.validation;

import com.jaspersoft.jasperserver.dto.adhoc.query.validation.ValidDomElType;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.JavaAliasConverter;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;

public class ValidDomElTypeValidator
implements ConstraintValidator<ValidDomElType, String>,
ValidationErrorDescriptorBuilder {
    String errorCode;
    String message;

    public void initialize(ValidDomElType constraintAnnotation) {
        this.errorCode = constraintAnnotation.errorCode();
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value != null) {
            return JavaAliasConverter.map.containsKey(value);
        }
        return Boolean.TRUE;
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        ErrorDescriptor errorDescriptor = new ErrorDescriptor().setErrorCode(this.errorCode).setMessage(this.message);
        errorDescriptor.addProperties(new ClientProperty("elementPath", violation.getPropertyPath().toString()), new ClientProperty("invalidValue", violation.getInvalidValue().toString()));
        return errorDescriptor;
    }
}

