/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.authority;

import com.jaspersoft.jasperserver.dto.authority.ClientRole;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Date;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="user")
public class ClientUser
implements DeepCloneable<ClientUser> {
    private Set<ClientRole> roleSet;
    private String fullName;
    private String password;
    private String emailAddress;
    private Boolean externallyDefined;
    private Boolean enabled;
    private Date previousPasswordChangeTime;
    private String tenantId;
    private String username;

    public ClientUser() {
    }

    public ClientUser(ClientUser other) {
        ValueObjectUtils.checkNotNull(other);
        this.roleSet = ValueObjectUtils.copyOf(other.getRoleSet());
        this.fullName = other.getFullName();
        this.password = other.getPassword();
        this.emailAddress = other.getEmailAddress();
        this.externallyDefined = other.isExternallyDefined();
        this.enabled = other.isEnabled();
        this.previousPasswordChangeTime = ValueObjectUtils.copyOf(other.getPreviousPasswordChangeTime());
        this.tenantId = other.getTenantId();
        this.username = other.getUsername();
    }

    @Override
    public ClientUser deepClone() {
        return new ClientUser(this);
    }

    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    public Set<ClientRole> getRoleSet() {
        return this.roleSet;
    }

    public ClientUser setRoleSet(Set<ClientRole> roleSet) {
        this.roleSet = roleSet;
        return this;
    }

    @XmlElement(name="fullName")
    public String getFullName() {
        return this.fullName;
    }

    public ClientUser setFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @XmlElement(name="password")
    public String getPassword() {
        return this.password;
    }

    public ClientUser setPassword(String password) {
        this.password = password;
        return this;
    }

    @XmlElement(name="emailAddress")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public ClientUser setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @XmlElement(name="externallyDefined")
    public Boolean isExternallyDefined() {
        return this.externallyDefined;
    }

    public ClientUser setExternallyDefined(Boolean externallyDefined) {
        this.externallyDefined = externallyDefined;
        return this;
    }

    @XmlElement(name="enabled")
    public Boolean isEnabled() {
        return this.enabled;
    }

    public ClientUser setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @XmlElement(name="previousPasswordChangeTime")
    public Date getPreviousPasswordChangeTime() {
        return this.previousPasswordChangeTime;
    }

    public ClientUser setPreviousPasswordChangeTime(Date previousPasswordChangeTime) {
        this.previousPasswordChangeTime = previousPasswordChangeTime;
        return this;
    }

    @XmlElement(name="tenantId")
    public String getTenantId() {
        return this.tenantId;
    }

    public ClientUser setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @XmlElement(name="username")
    public String getUsername() {
        return this.username;
    }

    public ClientUser setUsername(String username) {
        this.username = username;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientUser that = (ClientUser)o;
        if (this.roleSet != null ? !this.roleSet.equals(that.roleSet) : that.roleSet != null) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(that.fullName) : that.fullName != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.emailAddress != null ? !this.emailAddress.equals(that.emailAddress) : that.emailAddress != null) {
            return false;
        }
        if (this.externallyDefined != null ? !this.externallyDefined.equals(that.externallyDefined) : that.externallyDefined != null) {
            return false;
        }
        if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
            return false;
        }
        if (this.previousPasswordChangeTime != null ? !this.previousPasswordChangeTime.equals(that.previousPasswordChangeTime) : that.previousPasswordChangeTime != null) {
            return false;
        }
        if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
            return false;
        }
        return this.username != null ? this.username.equals(that.username) : that.username == null;
    }

    public int hashCode() {
        int result = this.roleSet != null ? this.roleSet.hashCode() : 0;
        result = 31 * result + (this.fullName != null ? this.fullName.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.emailAddress != null ? this.emailAddress.hashCode() : 0);
        result = 31 * result + (this.externallyDefined != null ? this.externallyDefined.hashCode() : 0);
        result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
        result = 31 * result + (this.previousPasswordChangeTime != null ? this.previousPasswordChangeTime.hashCode() : 0);
        result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientUser{roleSet=" + this.roleSet + ", fullName='" + this.fullName + '\'' + ", password='" + this.password + '\'' + ", emailAddress='" + this.emailAddress + '\'' + ", externallyDefined=" + this.externallyDefined + ", enabled=" + this.enabled + ", previousPasswordChangeTime=" + this.previousPasswordChangeTime + ", tenantId='" + this.tenantId + '\'' + ", username='" + this.username + '\'' + '}';
    }
}

