/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.authority.hypermedia;

import com.jaspersoft.jasperserver.dto.authority.ClientAttribute;
import com.jaspersoft.jasperserver.dto.authority.hypermedia.HypermediaAttribute;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="attributes")
public class HypermediaAttributesListWrapper
implements DeepCloneable<HypermediaAttributesListWrapper> {
    private List<HypermediaAttribute> profileAttributes;

    public HypermediaAttributesListWrapper() {
    }

    public HypermediaAttributesListWrapper(List<? extends ClientAttribute> attributes) {
        this.profileAttributes = new ArrayList<HypermediaAttribute>(attributes.size());
        for (ClientAttribute clientAttribute : attributes) {
            if (clientAttribute instanceof HypermediaAttribute) {
                this.profileAttributes.add((HypermediaAttribute)clientAttribute);
                continue;
            }
            this.profileAttributes.add(new HypermediaAttribute(clientAttribute));
        }
    }

    public HypermediaAttributesListWrapper(HypermediaAttributesListWrapper other) {
        ValueObjectUtils.checkNotNull(other);
        this.profileAttributes = ValueObjectUtils.copyOf(other.getProfileAttributes());
    }

    @Override
    public HypermediaAttributesListWrapper deepClone() {
        return new HypermediaAttributesListWrapper(this);
    }

    @XmlElement(name="attribute")
    public List<HypermediaAttribute> getProfileAttributes() {
        return this.profileAttributes;
    }

    public HypermediaAttributesListWrapper setProfileAttributes(List<HypermediaAttribute> profileAttributes) {
        this.profileAttributes = profileAttributes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HypermediaAttributesListWrapper that = (HypermediaAttributesListWrapper)o;
        return this.profileAttributes != null ? this.profileAttributes.equals(that.profileAttributes) : that.profileAttributes == null;
    }

    public int hashCode() {
        return this.profileAttributes != null ? this.profileAttributes.hashCode() : 0;
    }

    public String toString() {
        return "HypermediaAttributesListWrapper{profileAttributes=" + this.profileAttributes + '}';
    }
}

