/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.common;

import com.jaspersoft.jasperserver.dto.common.CommonErrorCode;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptorTemplate;
import java.util.HashMap;
import java.util.Map;

public enum AttributeErrorCode implements ErrorDescriptorTemplate
{
    ATTRIBUTE_PATTERNS_INCLUDES_INVALID("attribute.patterns.contains.invalid", CommonErrorCode.paramNames("invalidAttributePattern", "namedCapturingGroups")),
    PROFILE_ATTRIBUTE_SUBSTITUTION_NOT_FOUND("profile.attribute.substitution.not.found", CommonErrorCode.paramNames("attributeName", "hierarchyName")),
    PROFILE_ATTRIBUTE_SUBSTITUTION_CATEGORY_INVALID("profile.attribute.substitution.category.invalid", CommonErrorCode.paramNames("invalidAttributeCategory", "attributeName", "availableCategories")),
    PROFILE_ATTRIBUTE_SUBSTITUTION_NOT_FOUND_IN_RESOURCE("profile.attribute.substitution.not.found.in.resource", CommonErrorCode.paramNames("resourceURI", "resourceField", "attributeName", "categoryName")),
    PROFILE_ATTRIBUTE_SUBSTITUTION_CATEGORY_INVALID_IN_RESOURCE("profile.attribute.substitution.category.invalid.in.resource", CommonErrorCode.paramNames("resourceURI", "resourceField", "invalidAttributeCategory", "attributeName", "availableCategories"));

    String code;
    String[] paramNames;
    private static final Map<String, AttributeErrorCode> stringToEnum;

    private AttributeErrorCode(String code, String[] paramNames) {
        this.code = code;
        this.paramNames = paramNames;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String[] getParamNames() {
        return this.paramNames;
    }

    @Override
    public ErrorDescriptor createDescriptor(Object ... propValues) {
        return new ErrorDescriptor().setErrorCode(this.code).setProperties(CommonErrorCode.buildProperties(this.paramNames, propValues));
    }

    public String toString() {
        return this.code;
    }

    public static AttributeErrorCode fromCode(String code) {
        return stringToEnum.get(code);
    }

    static {
        stringToEnum = new HashMap<String, AttributeErrorCode>();
        for (AttributeErrorCode code : AttributeErrorCode.values()) {
            stringToEnum.put(code.toString(), code);
        }
    }

    public static interface ParamNames {
        public static final String INVALID_ATTRIBUTE_PATTERN = "invalidAttributePattern";
        public static final String NAMED_CAPTURING_GROUPS = "namedCapturingGroups";
        public static final String ATTRIBUTE_NAME = "attributeName";
        public static final String HIERARCHY_NAME = "hierarchyName";
        public static final String INVALID_ATTRIBUTE_CATEGORY = "invalidAttributeCategory";
        public static final String AVAILABLE_CATEGORIES = "availableCategories";
        public static final String RESOURCE_URI = "resourceURI";
        public static final String RESOURCE_FIELD = "resourceField";
        public static final String CATEGORY_NAME = "categoryName";
    }

    public static interface Codes {
        public static final String ATTRIBUTE_PATTERNS_INCLUDES_INVALID = "attribute.patterns.contains.invalid";
        public static final String PROFILE_ATTRIBUTE_SUBSTITUTION_NOT_FOUND = "profile.attribute.substitution.not.found";
        public static final String PROFILE_ATTRIBUTE_SUBSTITUTION_CATEGORY_INVALID = "profile.attribute.substitution.category.invalid";
        public static final String PROFILE_ATTRIBUTE_SUBSTITUTION_NOT_FOUND_IN_RESOURCE = "profile.attribute.substitution.not.found.in.resource";
        public static final String PROFILE_ATTRIBUTE_SUBSTITUTION_CATEGORY_INVALID_IN_RESOURCE = "profile.attribute.substitution.category.invalid.in.resource";
    }
}

