/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.common;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptorTemplate;
import com.jaspersoft.jasperserver.dto.common.validations.ArrayUtils;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import java.util.ArrayList;
import java.util.List;

public enum CommonErrorCode implements ErrorDescriptorTemplate
{
    MANDATORY_PARAMETER_ERROR("mandatory.parameter.error", CommonErrorCode.paramNames("propertyPath")),
    EXCEPTION_REMOTE_ILLEGAL_PARAMETER_VALUE_ERROR("exception.remote.illegal.parameter.value.error", CommonErrorCode.paramNames("invalidParamName", "invalidParamValue", "errorMessage"));

    String code;
    String[] paramNames;

    private CommonErrorCode(String code, String[] paramNames) {
        this.code = code;
        this.paramNames = paramNames;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String[] getParamNames() {
        return this.paramNames;
    }

    @Override
    public ErrorDescriptor createDescriptor(Object ... propValues) {
        return new ErrorDescriptor().setErrorCode(this.code).setParameters(ArrayUtils.objArrayToStringArray(propValues)).setProperties(CommonErrorCode.buildProperties(this.paramNames, propValues));
    }

    public String toString() {
        return this.code;
    }

    public static String[] paramNames(String ... paramNames) {
        return paramNames;
    }

    public static List<ClientProperty> buildProperties(String[] paramNames, Object[] paramValues) {
        CommonErrorCode.checkPropValues(paramNames, paramValues);
        ArrayList<ClientProperty> properties = null;
        if (paramNames != null) {
            int index = 0;
            properties = new ArrayList<ClientProperty>();
            for (String paramName : paramNames) {
                properties.add(new ClientProperty().setKey(paramName).setValue(ArrayUtils.objectToString(paramValues[index])));
                ++index;
            }
        }
        return properties;
    }

    public static String[] toPropertyValues(List<ClientProperty> properties) {
        if (properties != null) {
            String[] propertyValues = new String[properties.size()];
            int index = 0;
            for (ClientProperty property : properties) {
                propertyValues[index++] = property.getValue();
            }
            return propertyValues;
        }
        return null;
    }

    public static void checkPropValues(String[] paramNames, Object[] paramValues) {
        if (!ArrayUtils.checkArraysLength(paramNames, paramValues)) {
            throw new IllegalArgumentException("The length arrays of parameter values is not equals to parameter names length");
        }
    }

    public static interface Params {
        public static final String PROPERTY_PATH = "propertyPath";
        public static final String INVALID_PARAM_NAME = "invalidParamName";
        public static final String INVALID_PARAM_VALUE = "invalidParamValue";
        public static final String ERROR_MESSAGE = "errorMessage";
    }

    public static interface Codes {
        public static final String MANDATORY_PARAMETER_ERROR = "mandatory.parameter.error";
        public static final String EXCEPTION_REMOTE_ILLEGAL_PARAMETER_VALUE_ERROR = "exception.remote.illegal.parameter.value.error";
    }
}

