/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.common;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class ErrorDescriptor
implements DeepCloneable<ErrorDescriptor>,
Serializable {
    public static final String ERROR_CODE_UNEXPECTED_ERROR = "unexpected.error";
    private String message;
    private String errorCode;
    private String[] parameters;
    private List<ClientProperty> properties;
    private List<ErrorDescriptor> details;
    private String errorUid;
    private Throwable exception;

    public ErrorDescriptor() {
    }

    public ErrorDescriptor(ErrorDescriptor ed) {
        ValueObjectUtils.checkNotNull(ed);
        this.message = ed.getMessage();
        this.errorCode = ed.getErrorCode();
        this.parameters = ed.getParameters();
        this.errorUid = ed.getErrorUid();
        this.exception = ed.getException();
        this.properties = ValueObjectUtils.copyOf(ed.getProperties());
        this.details = ValueObjectUtils.copyOf(ed.getDetails());
    }

    @XmlElementWrapper(name="details")
    @XmlElement(name="detail")
    public List<ErrorDescriptor> getDetails() {
        return this.details;
    }

    public ErrorDescriptor setDetails(List<ErrorDescriptor> details) {
        this.details = details;
        return this;
    }

    public ErrorDescriptor addDetails(ErrorDescriptor ... details) {
        List<ErrorDescriptor> descriptorList = Arrays.asList(details);
        if (this.details == null) {
            this.details = new ArrayList<ErrorDescriptor>(descriptorList);
        } else {
            this.details.addAll(descriptorList);
        }
        return this;
    }

    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    public List<ClientProperty> getProperties() {
        return this.properties;
    }

    public ErrorDescriptor setProperties(List<ClientProperty> properties) {
        this.properties = properties;
        return this;
    }

    public ErrorDescriptor addProperties(ClientProperty ... properties) {
        List<ClientProperty> clientProperties = Arrays.asList(properties);
        if (this.properties == null) {
            this.properties = new ArrayList<ClientProperty>(clientProperties);
        } else {
            this.properties.addAll(clientProperties);
        }
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public ErrorDescriptor setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public ErrorDescriptor setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public String[] getParameters() {
        return this.parameters;
    }

    public ErrorDescriptor setParameters(String ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public ErrorDescriptor addParameters(Object ... args) {
        if (args != null && args.length > 0) {
            LinkedList<String> values = new LinkedList<String>();
            for (Object arg : args) {
                if (arg != null) {
                    values.add(arg.toString());
                    continue;
                }
                values.add(null);
            }
            if (!values.isEmpty()) {
                this.parameters = values.toArray(new String[values.size()]);
            }
        }
        return this;
    }

    public String getErrorUid() {
        return this.errorUid;
    }

    public ErrorDescriptor setErrorUid(String errorUid) {
        this.errorUid = errorUid;
        return this;
    }

    public ErrorDescriptor setException(Throwable exception) {
        this.exception = exception;
        return this;
    }

    @XmlTransient
    public Throwable getException() {
        return this.exception;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ErrorDescriptor)) {
            return false;
        }
        ErrorDescriptor that = (ErrorDescriptor)o;
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.errorCode != null ? !this.errorCode.equals(that.errorCode) : that.errorCode != null) {
            return false;
        }
        if (!Arrays.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (this.properties == null & that.properties != null || this.properties != null & that.properties == null) {
            return false;
        }
        if (!(this.properties == null || that.properties == null || this.properties.containsAll(that.properties) && that.properties.containsAll(this.properties))) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.errorUid != null ? !this.errorUid.equals(that.errorUid) : that.errorUid != null) {
            return false;
        }
        return this.exception != null ? this.exception.equals(that.exception) : that.exception == null;
    }

    public int hashCode() {
        int result = this.message != null ? this.message.hashCode() : 0;
        result = 31 * result + (this.errorCode != null ? this.errorCode.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.parameters);
        int propertiesHashCode = 0;
        if (this.properties != null) {
            for (ClientProperty property : this.properties) {
                propertiesHashCode += property.hashCode();
            }
        }
        result = 31 * result + propertiesHashCode;
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        result = 31 * result + (this.errorUid != null ? this.errorUid.hashCode() : 0);
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ErrorDescriptor{message='" + this.message + '\'' + ", errorCode='" + this.errorCode + '\'' + ", parameters=" + Arrays.toString(this.parameters) + ", properties=" + this.properties + ", details=" + this.details + ", errorUid='" + this.errorUid + '\'' + ", exception=" + this.exception + '}';
    }

    @Override
    public ErrorDescriptor deepClone() {
        return new ErrorDescriptor(this);
    }
}

