/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavaAliasConverter {
    public static Map<String, JavaAliasType> map = new HashMap<String, JavaAliasType>(){
        {
            this.put("boolean", new JavaAliasType("boolean", Boolean.class));
            this.put("string", new JavaAliasType("string", String.class));
            this.put("byte", new JavaAliasType("byte", Byte.class));
            this.put("short", new JavaAliasType("short", Short.class));
            this.put("integer", new JavaAliasType("integer", Integer.class));
            this.put("long", new JavaAliasType("long", Long.class));
            this.put("bigInteger", new JavaAliasType("bigInteger", BigInteger.class));
            this.put("float", new JavaAliasType("float", Float.class));
            this.put("double", new JavaAliasType("double", Double.class));
            this.put("bigDecimal", new JavaAliasType("bigDecimal", BigDecimal.class));
            this.put("date", new JavaAliasType("date", Date.class, java.sql.Date.class));
            this.put("time", new JavaAliasType("time", Time.class));
            this.put("timestamp", new JavaAliasType("timestamp", Timestamp.class));
        }
    };

    public static String toAlias(String javaType) {
        for (Map.Entry<String, JavaAliasType> type : map.entrySet()) {
            if (!type.getValue().getTypes().contains(javaType)) continue;
            return type.getKey();
        }
        throw new IllegalArgumentException("Can not find alias for java type: " + javaType);
    }

    public static String toJavaType(String alias) {
        JavaAliasType result = map.get(alias);
        if (result != null) {
            return result.getDefaultJavaType().getName();
        }
        throw new IllegalArgumentException("Can not find java type for alias: " + alias);
    }

    private static class JavaAliasType {
        private String name;
        private Class defaultJavaType;
        private Set<String> types = new HashSet<String>();

        public JavaAliasType(String name, Class defaultJavaType, Class ... possibleTypes) {
            this.name = name;
            this.defaultJavaType = defaultJavaType;
            this.types.add(defaultJavaType.getName());
            for (Class t : possibleTypes) {
                this.types.add(t.getName());
            }
        }

        public JavaAliasType(String name, Class defaultJavaType) {
            this.name = name;
            this.defaultJavaType = defaultJavaType;
            this.types.add(defaultJavaType.getName());
        }

        public String getName() {
            return this.name;
        }

        public Class getDefaultJavaType() {
            return this.defaultJavaType;
        }

        public Set<String> getTypes() {
            return this.types;
        }
    }
}

