/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.common;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="warning")
public class WarningDescriptor
implements DeepCloneable<WarningDescriptor> {
    private String code;
    private String[] parameters;
    private String message;

    public WarningDescriptor(String code, String[] parameters, String message) {
        this.code = code;
        this.parameters = parameters;
        this.message = message;
    }

    public WarningDescriptor() {
    }

    public WarningDescriptor(WarningDescriptor warningDescriptor) {
        ValueObjectUtils.checkNotNull(warningDescriptor);
        this.code = warningDescriptor.getCode();
        this.parameters = ValueObjectUtils.copyOf(warningDescriptor.getParameters());
        this.message = warningDescriptor.getMessage();
    }

    @Override
    public WarningDescriptor deepClone() {
        return new WarningDescriptor(this);
    }

    @XmlElement(name="code")
    public String getCode() {
        return this.code;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public String[] getParameters() {
        return this.parameters;
    }

    @XmlElement(name="message")
    public String getMessage() {
        return this.message;
    }

    public WarningDescriptor setCode(String code) {
        this.code = code;
        return this;
    }

    public WarningDescriptor setParameters(String[] parameters) {
        this.parameters = parameters;
        return this;
    }

    public WarningDescriptor setMessage(String message) {
        this.message = message;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarningDescriptor that = (WarningDescriptor)o;
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (!Arrays.equals(this.parameters, that.parameters)) {
            return false;
        }
        return this.message != null ? this.message.equals(that.message) : that.message == null;
    }

    public int hashCode() {
        int result = this.code != null ? this.code.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.parameters);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WarningDescriptor{code='" + this.code + '\'' + ", parameters=" + Arrays.toString(this.parameters) + ", message='" + this.message + '\'' + '}';
    }
}

