/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.connection;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.common.ResourceLocation;
import com.jaspersoft.jasperserver.dto.connection.FtpConnection;
import com.jaspersoft.jasperserver.dto.connection.LfsConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

public class AbstractFileConnection<BuilderType extends AbstractFileConnection>
implements DeepCloneable<AbstractFileConnection> {
    @XmlElement(name="hasHeaderLine")
    private boolean hasHeaderLine;
    private ResourceLocation location;

    public AbstractFileConnection() {
    }

    public AbstractFileConnection(AbstractFileConnection source) {
        ValueObjectUtils.checkNotNull(source);
        this.hasHeaderLine = source.hasHeaderLine();
        this.location = ValueObjectUtils.copyOf(source.getLocation());
    }

    public boolean hasHeaderLine() {
        return this.hasHeaderLine;
    }

    public BuilderType setHasHeaderLine(boolean hasHeaderLine) {
        this.hasHeaderLine = hasHeaderLine;
        return (BuilderType)this;
    }

    @XmlElements(value={@XmlElement(name="repositoryLocation", type=ClientReference.class), @XmlElement(name="ftpLocation", type=FtpConnection.class), @XmlElement(name="lfcLocation", type=LfsConnection.class)})
    public ResourceLocation getLocation() {
        return this.location;
    }

    public BuilderType setLocation(ResourceLocation location) {
        this.location = location;
        return (BuilderType)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileConnection that = (AbstractFileConnection)o;
        if (this.hasHeaderLine != that.hasHeaderLine) {
            return false;
        }
        return !(this.location != null ? !this.location.equals(that.location) : that.location != null);
    }

    public int hashCode() {
        int result = this.hasHeaderLine ? 1 : 0;
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{hasHeaderLine=" + this.hasHeaderLine + ", location=" + this.location + "} " + super.toString();
    }

    @Override
    public AbstractFileConnection deepClone() {
        return new AbstractFileConnection<BuilderType>(this);
    }
}

