/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.connection.datadiscovery;

import com.jaspersoft.jasperserver.dto.connection.datadiscovery.UnexpectedEscapeCharacterException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotByTildaEscapeUtil {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!~)(?:~~)*\\.");
    private static final Pattern VALIDATE_PATTERN = Pattern.compile("(?<!~)(?:~~)*~(?!(~|\\.))");
    public static final String ESCAPE_CHARACTER = "~";
    public static final String DELIMITER_CHARACTER = ".";
    public static final String DOUBLE_ESCAPE_CHARACTER = "~~";
    public static final String ESCAPED_DELIMITER_CHARACTER = "~.";

    public String escapeDot(String toEscape) {
        String result = toEscape;
        if (result.contains(ESCAPE_CHARACTER)) {
            result = result.replace(ESCAPE_CHARACTER, DOUBLE_ESCAPE_CHARACTER);
        }
        if (result.contains(DELIMITER_CHARACTER)) {
            result = result.replace(DELIMITER_CHARACTER, ESCAPED_DELIMITER_CHARACTER);
        }
        return result;
    }

    public String unEscapeDot(String toUnEscape) {
        return this.unEscapeDot(toUnEscape, true);
    }

    protected String unEscapeDot(String toUnEscape, boolean validate) {
        String result;
        if (validate) {
            this.validateBeforeUnEscape(toUnEscape);
        }
        if ((result = toUnEscape).contains(DOUBLE_ESCAPE_CHARACTER)) {
            result = result.replace(DOUBLE_ESCAPE_CHARACTER, ESCAPE_CHARACTER);
        }
        if (result.contains(ESCAPED_DELIMITER_CHARACTER)) {
            result = result.replace(ESCAPED_DELIMITER_CHARACTER, DELIMITER_CHARACTER);
        }
        return result;
    }

    public String[] splitByDotUnEscapeTokens(String dotQualifiedString) {
        this.validateBeforeUnEscape(dotQualifiedString);
        if (dotQualifiedString == null) {
            return null;
        }
        Matcher matcher = SPLIT_PATTERN.matcher(dotQualifiedString);
        int start = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            int end = matcher.end();
            tokens.add(dotQualifiedString.substring(start, end - 1));
            start = end;
        }
        tokens.add(dotQualifiedString.substring(start, dotQualifiedString.length()));
        String[] split = tokens.toArray(new String[tokens.size()]);
        for (int i = 0; i < split.length; ++i) {
            split[i] = this.unEscapeDot(split[i], false);
        }
        return split;
    }

    protected void validateBeforeUnEscape(String string) {
        if (string.contains(DELIMITER_CHARACTER) || string.contains(ESCAPE_CHARACTER)) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            Matcher matcher = VALIDATE_PATTERN.matcher(string);
            while (matcher.find()) {
                indexes.add(matcher.end() - 1);
            }
            if (!indexes.isEmpty()) {
                throw new UnexpectedEscapeCharacterException(string, indexes);
            }
        }
    }

    public String toDotQualifiedString(String ... tokens) {
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String token : tokens) {
            if (builder.length() != 0) {
                builder.append(DELIMITER_CHARACTER);
            }
            builder.append(this.escapeDot(token));
        }
        return builder.toString();
    }
}

