/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.connection.datadiscovery;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.domain.ResourceGroupElement;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="flatDataSet")
public class FlatDataSet
implements DeepCloneable<FlatDataSet> {
    private List<String[]> data;
    private ResourceGroupElement metadata;

    public FlatDataSet() {
    }

    public FlatDataSet(FlatDataSet source) {
        ValueObjectUtils.checkNotNull(source);
        this.data = ValueObjectUtils.copyOf(source.getData());
        this.metadata = ValueObjectUtils.copyOf(source.getMetadata());
    }

    @XmlElementWrapper(name="rows")
    @XmlElement(name="row")
    public List<String[]> getData() {
        return this.data;
    }

    public FlatDataSet setData(List<String[]> data) {
        this.data = data;
        return this;
    }

    public ResourceGroupElement getMetadata() {
        return this.metadata;
    }

    public FlatDataSet setMetadata(ResourceGroupElement metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlatDataSet)) {
            return false;
        }
        FlatDataSet that = (FlatDataSet)o;
        if (this.data != null ? !ValueObjectUtils.isListsOfArraysEquals(this.data, that.data) : that.data != null) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
    }

    public int hashCode() {
        int result = ValueObjectUtils.hashCodeOfListOfArrays(this.data);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FlatDataSet{data=" + this.data + ", metadata=" + this.metadata + '}';
    }

    @Override
    public FlatDataSet deepClone() {
        return new FlatDataSet(this);
    }
}

