/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.customdatasources;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.customdatasources.CustomDataSourcePropertyDefinition;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="definition")
public class ClientCustomDataSourceDefinition
implements DeepCloneable<ClientCustomDataSourceDefinition> {
    private String name;
    private List<String> queryTypes;
    private List<CustomDataSourcePropertyDefinition> propertyDefinitions;
    private Boolean testable;

    public ClientCustomDataSourceDefinition() {
    }

    public ClientCustomDataSourceDefinition(ClientCustomDataSourceDefinition source) {
        ValueObjectUtils.checkNotNull(source);
        this.name = source.getName();
        this.queryTypes = ValueObjectUtils.copyOf(source.getQueryTypes());
        this.propertyDefinitions = ValueObjectUtils.copyOf(source.getPropertyDefinitions());
        this.testable = source.getTestable();
    }

    public Boolean getTestable() {
        return this.testable;
    }

    public ClientCustomDataSourceDefinition setTestable(Boolean testable) {
        this.testable = testable;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ClientCustomDataSourceDefinition setName(String name) {
        this.name = name;
        return this;
    }

    @XmlElementWrapper(name="queryTypes")
    @XmlElement(name="queryType")
    public List<String> getQueryTypes() {
        return this.queryTypes;
    }

    public ClientCustomDataSourceDefinition setQueryTypes(List<String> queryTypes) {
        this.queryTypes = queryTypes;
        return this;
    }

    @XmlElementWrapper(name="propertyDefinitions")
    @XmlElement(name="propertyDefinition")
    public List<CustomDataSourcePropertyDefinition> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public ClientCustomDataSourceDefinition setPropertyDefinitions(List<CustomDataSourcePropertyDefinition> propertyDefinitions) {
        this.propertyDefinitions = propertyDefinitions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCustomDataSourceDefinition that = (ClientCustomDataSourceDefinition)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.propertyDefinitions != null ? !this.propertyDefinitions.equals(that.propertyDefinitions) : that.propertyDefinitions != null) {
            return false;
        }
        if (this.queryTypes != null ? !this.queryTypes.equals(that.queryTypes) : that.queryTypes != null) {
            return false;
        }
        return !(this.testable != null ? !this.testable.equals(that.testable) : that.testable != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.queryTypes != null ? this.queryTypes.hashCode() : 0);
        result = 31 * result + (this.propertyDefinitions != null ? this.propertyDefinitions.hashCode() : 0);
        result = 31 * result + (this.testable != null ? this.testable.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientCustomDataSourceDefinition{name='" + this.name + '\'' + ", queryTypes=" + this.queryTypes + ", propertyDefinitions=" + this.propertyDefinitions + ", testable=" + this.testable + '}';
    }

    @Override
    public ClientCustomDataSourceDefinition deepClone() {
        return new ClientCustomDataSourceDefinition(this);
    }
}

