/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.customdatasources;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="propertyDefinition")
public class CustomDataSourcePropertyDefinition
implements DeepCloneable<CustomDataSourcePropertyDefinition> {
    private String name;
    private String label;
    private String defaultValue;
    private List<ClientProperty> properties;

    public CustomDataSourcePropertyDefinition() {
    }

    public CustomDataSourcePropertyDefinition(CustomDataSourcePropertyDefinition source) {
        ValueObjectUtils.checkNotNull(source);
        this.name = source.getName();
        this.defaultValue = source.getDefaultValue();
        this.label = source.getLabel();
        this.properties = ValueObjectUtils.copyOf(source.getProperties());
    }

    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    public List<ClientProperty> getProperties() {
        return this.properties;
    }

    public CustomDataSourcePropertyDefinition setProperties(List<ClientProperty> properties) {
        this.properties = properties;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public CustomDataSourcePropertyDefinition setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CustomDataSourcePropertyDefinition setName(String name) {
        this.name = name;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public CustomDataSourcePropertyDefinition setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomDataSourcePropertyDefinition that = (CustomDataSourcePropertyDefinition)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) {
            return false;
        }
        return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CustomDataSourcePropertyDefinition{name='" + this.name + '\'' + ", label='" + this.label + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", properties=" + this.properties + '}';
    }

    @Override
    public CustomDataSourcePropertyDefinition deepClone() {
        return new CustomDataSourcePropertyDefinition(this);
    }
}

