/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.dashboard;

import com.jaspersoft.jasperserver.dto.authority.ClientUser;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.dashboard.DashboardParameters;
import com.jaspersoft.jasperserver.dto.dashboard.RuntimeComponent;
import com.jaspersoft.jasperserver.dto.resources.ClientDashboard;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="dashboardExportExecution")
public class DashboardExportExecution
implements DeepCloneable<DashboardExportExecution> {
    private Boolean detailed;
    private int width;
    private int height;
    private int referenceWidth;
    private int referenceHeight;
    private ExportFormat format;
    private String uri;
    private String id;
    private DashboardParameters parameters;
    private String markup;
    private List<String> jrStyle;
    private List<RuntimeComponent> runtimeComponents;
    private ClientDashboard dashboard;
    private String outputTimeZone;
    private String outputLocale;
    private ClientUser owner;

    public DashboardExportExecution() {
    }

    public DashboardExportExecution(DashboardExportExecution other) {
        ValueObjectUtils.checkNotNull(other);
        this.detailed = other.detailed;
        this.width = other.width;
        this.height = other.height;
        this.referenceWidth = other.referenceWidth;
        this.referenceHeight = other.referenceHeight;
        this.format = other.format;
        this.uri = other.uri;
        this.id = other.id;
        this.parameters = ValueObjectUtils.copyOf(other.getParameters());
        this.markup = other.markup;
        this.jrStyle = ValueObjectUtils.copyOf(other.getJrStyle());
        this.runtimeComponents = ValueObjectUtils.copyOf(other.getRuntimeComponents());
        this.dashboard = ValueObjectUtils.copyOf(other.getDashboard());
        this.outputTimeZone = other.outputTimeZone;
        this.outputLocale = other.outputLocale;
        if (other.owner != null) {
            this.owner = new ClientUser(other.owner);
        }
    }

    public Boolean getDetailed() {
        return this.detailed;
    }

    public DashboardExportExecution setDetailed(Boolean detailed) {
        this.detailed = detailed;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public DashboardExportExecution setWidth(int width) {
        this.width = width;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public DashboardExportExecution setHeight(int heigt) {
        this.height = heigt;
        return this;
    }

    public ExportFormat getFormat() {
        return this.format;
    }

    public DashboardExportExecution setFormat(ExportFormat format) {
        this.format = format;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public DashboardExportExecution setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public DashboardParameters getParameters() {
        return this.parameters;
    }

    public DashboardExportExecution setParameters(DashboardParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public DashboardExportExecution setId(String id) {
        this.id = id;
        return this;
    }

    public String getMarkup() {
        return this.markup;
    }

    public DashboardExportExecution setMarkup(String markup) {
        this.markup = markup;
        return this;
    }

    public List<String> getJrStyle() {
        return this.jrStyle;
    }

    public DashboardExportExecution setJrStyle(List<String> jrStyle) {
        this.jrStyle = jrStyle;
        return this;
    }

    public int getReferenceWidth() {
        return this.referenceWidth;
    }

    public DashboardExportExecution setReferenceWidth(int referenceWidth) {
        this.referenceWidth = referenceWidth;
        return this;
    }

    public int getReferenceHeight() {
        return this.referenceHeight;
    }

    public DashboardExportExecution setReferenceHeight(int referenceHeight) {
        this.referenceHeight = referenceHeight;
        return this;
    }

    public String getOutputTimeZone() {
        return this.outputTimeZone;
    }

    public DashboardExportExecution setOutputTimeZone(String outputTimeZone) {
        this.outputTimeZone = outputTimeZone;
        return this;
    }

    public String getOutputLocale() {
        return this.outputLocale;
    }

    public DashboardExportExecution setOutputLocale(String outputLocale) {
        this.outputLocale = outputLocale;
        return this;
    }

    public ClientUser getOwner() {
        return this.owner;
    }

    public DashboardExportExecution setOwner(ClientUser owner) {
        this.owner = owner;
        return this;
    }

    public List<RuntimeComponent> getRuntimeComponents() {
        return this.runtimeComponents;
    }

    public void setRuntimeComponents(List<RuntimeComponent> runtimeComponents) {
        this.runtimeComponents = runtimeComponents;
    }

    public ClientDashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(ClientDashboard dashboard) {
        this.dashboard = dashboard;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardExportExecution that = (DashboardExportExecution)o;
        if (this.detailed != null ? !this.detailed.equals(that.detailed) : that.detailed != null) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (this.referenceWidth != that.referenceWidth) {
            return false;
        }
        if (this.referenceHeight != that.referenceHeight) {
            return false;
        }
        if (this.format != that.format) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.markup != null ? !this.markup.equals(that.markup) : that.markup != null) {
            return false;
        }
        if (this.jrStyle != null ? !this.jrStyle.equals(that.jrStyle) : that.jrStyle != null) {
            return false;
        }
        if (this.runtimeComponents != null ? !this.runtimeComponents.equals(that.runtimeComponents) : that.runtimeComponents != null) {
            return false;
        }
        if (this.dashboard != null ? !this.dashboard.equals(that.dashboard) : that.dashboard != null) {
            return false;
        }
        if (this.outputTimeZone != null ? !this.outputTimeZone.equals(that.outputTimeZone) : that.outputTimeZone != null) {
            return false;
        }
        return this.outputLocale != null ? this.outputLocale.equals(that.outputLocale) : that.outputLocale == null;
    }

    public int hashCode() {
        int result = this.detailed != null ? this.detailed.hashCode() : 0;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.referenceWidth;
        result = 31 * result + this.referenceHeight;
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        result = 31 * result + (this.markup != null ? this.markup.hashCode() : 0);
        result = 31 * result + (this.jrStyle != null ? this.jrStyle.hashCode() : 0);
        result = 31 * result + (this.runtimeComponents != null ? this.runtimeComponents.hashCode() : 0);
        result = 31 * result + (this.dashboard != null ? this.dashboard.hashCode() : 0);
        result = 31 * result + (this.outputTimeZone != null ? this.outputTimeZone.hashCode() : 0);
        result = 31 * result + (this.outputLocale != null ? this.outputLocale.hashCode() : 0);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DashboardExportExecution{detailed=" + this.detailed + ", width=" + this.width + ", height=" + this.height + ", referenceWidth=" + this.referenceWidth + ", referenceHeight=" + this.referenceHeight + ", format=" + (Object)((Object)this.format) + ", uri='" + this.uri + '\'' + ", id='" + this.id + '\'' + ", parameters=" + this.parameters + ", markup='" + this.markup + '\'' + ", jrStyle=" + this.jrStyle + ", runtimeComponents=" + this.runtimeComponents + ", dashboard=" + this.dashboard + ", outputTimeZone='" + this.outputTimeZone + '\'' + ", outputLocale='" + this.outputLocale + '\'' + ", owner='" + (this.owner != null ? this.owner.getUsername() : this.owner) + '\'' + '}';
    }

    @Override
    public DashboardExportExecution deepClone() {
        return new DashboardExportExecution(this);
    }

    public static enum ExportFormat {
        png("image/png"),
        pptx("application/vnd.openxmlformats-officedocument.presentationml.presentation"),
        docx("application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
        odt("application/vnd.oasis.opendocument.text"),
        pdf("application/pdf"),
        xlsx("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
        xls("application/vnd.ms-excel"),
        rtf("application/rtf"),
        csv("application/vnd.ms-excel"),
        ods("application/vnd.oasis.opendocument.spreadsheet");

        private String mime;

        private ExportFormat(String mime) {
            this.mime = mime;
        }

        public String getMimeFormat() {
            return this.mime;
        }
    }
}

