/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.dashboard;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.reports.ReportParameter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class DashboardParameters
implements DeepCloneable<DashboardParameters> {
    private List<ReportParameter> dashboardParameters;

    public DashboardParameters() {
    }

    public DashboardParameters(List<ReportParameter> dashboardParameters) {
        this.dashboardParameters = dashboardParameters;
    }

    public DashboardParameters(DashboardParameters other) {
        ValueObjectUtils.checkNotNull(other);
        this.dashboardParameters = ValueObjectUtils.copyOf(other.getDashboardParameters());
    }

    @XmlElement(name="dashboardParameter")
    public List<ReportParameter> getDashboardParameters() {
        return this.dashboardParameters;
    }

    public DashboardParameters setDashboardParameters(List<ReportParameter> dashboardParameters) {
        this.dashboardParameters = dashboardParameters;
        return this;
    }

    @XmlTransient
    public Map<String, String[]> getRawParameters() {
        HashMap<String, String[]> rawParameters = new HashMap<String, String[]>();
        if (this.dashboardParameters != null) {
            for (ReportParameter currentParameter : this.dashboardParameters) {
                rawParameters.put(currentParameter.getName(), currentParameter.getValues().toArray(new String[currentParameter.getValues().size()]));
            }
        }
        return rawParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardParameters that = (DashboardParameters)o;
        return this.dashboardParameters != null ? this.dashboardParameters.equals(that.dashboardParameters) : that.dashboardParameters == null;
    }

    public int hashCode() {
        return this.dashboardParameters != null ? this.dashboardParameters.hashCode() : 0;
    }

    public String toString() {
        return "DashboardParameters{dashboardParameters=" + this.dashboardParameters + '}';
    }

    @Override
    public DashboardParameters deepClone() {
        return new DashboardParameters(this);
    }
}

