/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.domain;

import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public abstract class AbstractDomainMetaEntity {
    private String id;
    private String label;
    private Map<String, String> properties;

    public AbstractDomainMetaEntity() {
    }

    public AbstractDomainMetaEntity(AbstractDomainMetaEntity other) {
        ValueObjectUtils.checkNotNull(other);
        this.id = other.id;
        this.label = other.label;
        this.properties = ValueObjectUtils.copyOf(other.getProperties());
    }

    public String getId() {
        return this.id;
    }

    public AbstractDomainMetaEntity setId(String id) {
        this.id = id;
        return this;
    }

    @XmlElement(name="label", required=false)
    public String getLabel() {
        return this.label;
    }

    public AbstractDomainMetaEntity setLabel(String label) {
        this.label = label;
        return this;
    }

    @XmlElementWrapper(name="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public AbstractDomainMetaEntity setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public AbstractDomainMetaEntity addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDomainMetaEntity that = (AbstractDomainMetaEntity)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

