/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.domain;

import com.jaspersoft.jasperserver.dto.adhoc.query.validation.ValidDomElType;
import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.domain.DomElVariable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public abstract class BaseDomElContext<FinalType extends BaseDomElContext<FinalType>>
implements DeepCloneable<FinalType> {
    @Valid
    private List<DomElVariable> variables;
    private List<String> forbiddenVariableNames;
    @ValidDomElType(errorCode="domel.invalid.result.type", message="Invalid expression result type")
    private String resultType;
    private Boolean aggregate;
    private Boolean nonStrictMode;
    private Boolean skipUndefinedVariablesCheck;
    private Boolean skipTypeAndFunctionsValidation;

    public BaseDomElContext() {
    }

    public BaseDomElContext(BaseDomElContext source) {
        ValueObjectUtils.checkNotNull(source);
        this.variables = ValueObjectUtils.copyOf(source.getVariables());
        this.forbiddenVariableNames = ValueObjectUtils.copyOf(source.getForbiddenVariableNames());
        this.resultType = source.getResultType();
        this.aggregate = source.getAggregate();
        this.nonStrictMode = source.getNonStrictMode();
        this.skipTypeAndFunctionsValidation = source.getSkipTypeAndFunctionsValidation();
        this.skipUndefinedVariablesCheck = source.getSkipUndefinedVariablesCheck();
    }

    public Boolean getSkipTypeAndFunctionsValidation() {
        return this.skipTypeAndFunctionsValidation;
    }

    public FinalType setSkipTypeAndFunctionsValidation(Boolean skipTypeAndFunctionsValidation) {
        this.skipTypeAndFunctionsValidation = skipTypeAndFunctionsValidation;
        return (FinalType)this;
    }

    public Boolean getNonStrictMode() {
        return this.nonStrictMode;
    }

    public FinalType setNonStrictMode(Boolean nonStrictMode) {
        this.nonStrictMode = nonStrictMode;
        return (FinalType)this;
    }

    public Boolean getSkipUndefinedVariablesCheck() {
        return this.skipUndefinedVariablesCheck;
    }

    public FinalType setSkipUndefinedVariablesCheck(Boolean skipUndefinedVariablesCheck) {
        this.skipUndefinedVariablesCheck = skipUndefinedVariablesCheck;
        return (FinalType)this;
    }

    public Boolean getAggregate() {
        return this.aggregate;
    }

    public FinalType setAggregate(Boolean aggregate) {
        this.aggregate = aggregate;
        return (FinalType)this;
    }

    @XmlElementWrapper(name="variables")
    @XmlElement(name="variable")
    public List<DomElVariable> getVariables() {
        return this.variables;
    }

    public FinalType setVariables(List<DomElVariable> variables) {
        this.variables = variables;
        return (FinalType)this;
    }

    public List<String> getForbiddenVariableNames() {
        return this.forbiddenVariableNames;
    }

    public FinalType addForbiddenVariableNames(String ... names) {
        List<String> forbiddenNames = Arrays.asList(names);
        if (this.forbiddenVariableNames == null) {
            this.forbiddenVariableNames = forbiddenNames;
        } else {
            this.forbiddenVariableNames.addAll(forbiddenNames);
        }
        return (FinalType)this;
    }

    public FinalType setForbiddenVariableNames(List<String> forbiddenVariableNames) {
        this.forbiddenVariableNames = forbiddenVariableNames;
        return (FinalType)this;
    }

    public String getResultType() {
        return this.resultType;
    }

    public FinalType setResultType(String resultType) {
        this.resultType = resultType;
        return (FinalType)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseDomElContext that = (BaseDomElContext)o;
        if (this.variables != null ? !this.variables.equals(that.variables) : that.variables != null) {
            return false;
        }
        if (this.forbiddenVariableNames != null ? !this.forbiddenVariableNames.equals(that.forbiddenVariableNames) : that.forbiddenVariableNames != null) {
            return false;
        }
        if (this.resultType != null ? !this.resultType.equals(that.resultType) : that.resultType != null) {
            return false;
        }
        if (this.aggregate != null ? !this.aggregate.equals(that.aggregate) : that.aggregate != null) {
            return false;
        }
        if (this.nonStrictMode != null ? !this.nonStrictMode.equals(that.nonStrictMode) : that.nonStrictMode != null) {
            return false;
        }
        if (this.skipUndefinedVariablesCheck != null ? !this.skipUndefinedVariablesCheck.equals(that.skipUndefinedVariablesCheck) : that.skipUndefinedVariablesCheck != null) {
            return false;
        }
        return this.skipTypeAndFunctionsValidation != null ? this.skipTypeAndFunctionsValidation.equals(that.skipTypeAndFunctionsValidation) : that.skipTypeAndFunctionsValidation == null;
    }

    public int hashCode() {
        int result = this.variables != null ? this.variables.hashCode() : 0;
        result = 31 * result + (this.forbiddenVariableNames != null ? this.forbiddenVariableNames.hashCode() : 0);
        result = 31 * result + (this.resultType != null ? this.resultType.hashCode() : 0);
        result = 31 * result + (this.aggregate != null ? this.aggregate.hashCode() : 0);
        result = 31 * result + (this.nonStrictMode != null ? this.nonStrictMode.hashCode() : 0);
        result = 31 * result + (this.skipUndefinedVariablesCheck != null ? this.skipUndefinedVariablesCheck.hashCode() : 0);
        result = 31 * result + (this.skipTypeAndFunctionsValidation != null ? this.skipTypeAndFunctionsValidation.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{variables=" + this.variables + ", forbiddenVariableNames=" + this.forbiddenVariableNames + ", resultType='" + this.resultType + '\'' + ", aggregate=" + this.aggregate + ", nonStrictMode=" + this.nonStrictMode + ", skipUndefinedVariablesCheck=" + this.skipUndefinedVariablesCheck + ", skipTypeAndFunctionsValidation=" + this.skipTypeAndFunctionsValidation + '}';
    }
}

