/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.domain;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.domain.DomainMetaLevel;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="domainMetadata")
public class DomainMetaData
implements DeepCloneable<DomainMetaData> {
    private Map<String, String> properties;
    private DomainMetaLevel rootLevel;

    public DomainMetaData() {
    }

    public DomainMetaData(DomainMetaData other) {
        ValueObjectUtils.checkNotNull(other);
        this.properties = ValueObjectUtils.copyOf(other.getProperties());
        this.rootLevel = ValueObjectUtils.copyOf(other.getRootLevel());
    }

    @XmlElementWrapper(name="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainMetaData that = (DomainMetaData)o;
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.rootLevel != null ? !this.rootLevel.equals(that.rootLevel) : that.rootLevel != null);
    }

    public int hashCode() {
        int result = this.properties != null ? this.properties.hashCode() : 0;
        result = 31 * result + (this.rootLevel != null ? this.rootLevel.hashCode() : 0);
        return result;
    }

    public DomainMetaData addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
        return this;
    }

    public DomainMetaData setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public DomainMetaLevel getRootLevel() {
        return this.rootLevel;
    }

    public DomainMetaData setRootLevel(DomainMetaLevel rootLevel) {
        this.rootLevel = rootLevel;
        return this;
    }

    public String toString() {
        return "DomainMetaData{properties=" + this.properties + ", rootLevel=" + this.rootLevel + '}';
    }

    @Override
    public DomainMetaData deepClone() {
        return new DomainMetaData(this);
    }
}

