/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.domain;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.domain.AbstractDomainMetaEntity;
import com.jaspersoft.jasperserver.dto.domain.DomainMetaItem;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class DomainMetaLevel
extends AbstractDomainMetaEntity
implements DeepCloneable<DomainMetaLevel> {
    private List<DomainMetaItem> items;
    private List<DomainMetaLevel> subLevels;

    public DomainMetaLevel() {
    }

    public DomainMetaLevel(DomainMetaLevel other) {
        super(other);
        this.items = ValueObjectUtils.copyOf(other.items);
        this.subLevels = ValueObjectUtils.copyOf(other.subLevels);
    }

    @XmlElementWrapper(name="items")
    @XmlElement(name="item", type=DomainMetaItem.class)
    public List<DomainMetaItem> getItems() {
        return this.items;
    }

    public DomainMetaLevel setItems(List<DomainMetaItem> items) {
        this.items = items;
        return this;
    }

    public DomainMetaLevel addItem(DomainMetaItem item) {
        if (this.items == null) {
            this.items = new ArrayList<DomainMetaItem>();
        }
        this.items.add(item);
        return this;
    }

    @XmlElementWrapper(name="subLevels")
    @XmlElement(name="subLevel", type=DomainMetaLevel.class)
    public List<DomainMetaLevel> getSubLevels() {
        return this.subLevels;
    }

    public DomainMetaLevel setSubLevels(List<DomainMetaLevel> subLevels) {
        this.subLevels = subLevels;
        return this;
    }

    public DomainMetaLevel addSubLevel(DomainMetaLevel subLevel) {
        if (this.subLevels == null) {
            this.subLevels = new ArrayList<DomainMetaLevel>();
        }
        this.subLevels.add(subLevel);
        return this;
    }

    public String toString() {
        return "DomainMetaLevel{id='" + this.getId() + '\'' + ", label='" + this.getLabel() + '\'' + ", items=" + this.items + ", subLevels=" + this.subLevels + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DomainMetaLevel that = (DomainMetaLevel)o;
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        return !(this.subLevels != null ? !this.subLevels.equals(that.subLevels) : that.subLevels != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 31 * result + (this.subLevels != null ? this.subLevels.hashCode() : 0);
        return result;
    }

    @Override
    public DomainMetaLevel deepClone() {
        return new DomainMetaLevel(this);
    }
}

