/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.executions;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.executions.ClientQueryParams;
import com.jaspersoft.jasperserver.dto.executions.ExecutionStatusObject;
import com.jaspersoft.jasperserver.dto.executions.validation.CheckInMemoryDataSourceType;
import com.jaspersoft.jasperserver.dto.resources.ClientAdhocDataView;
import com.jaspersoft.jasperserver.dto.resources.ClientAwsDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientAzureSqlDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientBeanDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientJndiJdbcDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceable;
import com.jaspersoft.jasperserver.dto.resources.ClientReportUnit;
import com.jaspersoft.jasperserver.dto.resources.ClientSemanticLayerDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientTopic;
import com.jaspersoft.jasperserver.dto.resources.ClientVirtualDataSource;
import com.jaspersoft.jasperserver.dto.resources.domain.ClientDomain;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

public abstract class AbstractClientExecution<T extends AbstractClientExecution<T>>
implements DeepCloneable<T> {
    @Valid
    private ClientQueryParams params;
    @NotNull
    @CheckInMemoryDataSourceType
    private ClientReferenceable dataSource;
    private String id;
    private ExecutionStatusObject status;
    private List<ClientReferenceable> resources;

    public AbstractClientExecution() {
    }

    public AbstractClientExecution(AbstractClientExecution<T> clientExecution) {
        ValueObjectUtils.checkNotNull(clientExecution);
        this.params = ValueObjectUtils.copyOf(clientExecution.getParams());
        this.dataSource = ValueObjectUtils.copyOf(clientExecution.dataSource);
        this.id = clientExecution.id;
        this.status = ValueObjectUtils.copyOf(clientExecution.status);
    }

    public ClientQueryParams getParams() {
        return this.params;
    }

    public T setParams(ClientQueryParams params) {
        this.params = params;
        return (T)this;
    }

    @XmlElements(value={@XmlElement(type=ClientReference.class, name="reference"), @XmlElement(type=ClientDomain.class, name="domain"), @XmlElement(type=ClientAwsDataSource.class, name="awsDataSource"), @XmlElement(type=ClientBeanDataSource.class, name="beanDataSource"), @XmlElement(type=ClientCustomDataSource.class, name="customDataSource"), @XmlElement(type=ClientJdbcDataSource.class, name="jdbcDataSource"), @XmlElement(type=ClientJndiJdbcDataSource.class, name="jndiJdbcDataSource"), @XmlElement(type=ClientVirtualDataSource.class, name="virtualDataSource"), @XmlElement(type=ClientSemanticLayerDataSource.class, name="semanticLayerDataSource"), @XmlElement(type=ClientAdhocDataView.class, name="adhocDataView"), @XmlElement(type=ClientTopic.class, name="topic"), @XmlElement(type=ClientAzureSqlDataSource.class, name="azureSqlDataSource")})
    public ClientReferenceable getDataSource() {
        return this.dataSource;
    }

    public T setDataSource(ClientReferenceable dataSource) {
        this.dataSource = dataSource;
        return (T)this;
    }

    @XmlElement(name="id")
    public String getId() {
        return this.id;
    }

    public T setId(String id) {
        this.id = id;
        return (T)this;
    }

    @XmlElement(name="status")
    public ExecutionStatusObject getStatus() {
        return this.status;
    }

    public T setStatus(ExecutionStatusObject status) {
        this.status = status;
        return (T)this;
    }

    @XmlElementWrapper(name="resources")
    @XmlElements(value={@XmlElement(name="reference", type=ClientReference.class), @XmlElement(name="file", type=ClientFile.class), @XmlElement(name="reportUnit", type=ClientReportUnit.class), @XmlElement(name="adhocDataView", type=ClientAdhocDataView.class), @XmlElement(name="semanticLayerDataSource", type=ClientSemanticLayerDataSource.class), @XmlElement(name="customDataSource", type=ClientCustomDataSource.class), @XmlElement(name="jdbcDataSource", type=ClientJdbcDataSource.class), @XmlElement(name="jndiJdbcDataSource", type=ClientJndiJdbcDataSource.class), @XmlElement(name="azureSqlDataSource", type=ClientAzureSqlDataSource.class), @XmlElement(name="awsDataSource", type=ClientAwsDataSource.class), @XmlElement(name="topic", type=ClientTopic.class)})
    public List<ClientReferenceable> getResources() {
        return this.resources;
    }

    public T setResources(List<ClientReferenceable> resources) {
        this.resources = resources;
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractClientExecution that = (AbstractClientExecution)o;
        if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.resources != null ? !this.resources.equals(that.resources) : that.resources != null);
    }

    public int hashCode() {
        int result = this.params != null ? this.params.hashCode() : 0;
        result = 31 * result + (this.dataSource != null ? this.dataSource.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AbstractClientExecution{params=" + this.params + ", dataSource=" + this.dataSource + ", id='" + this.id + '\'' + ", status=" + this.status + ", resources=" + this.resources + '}';
    }

    @Override
    public abstract T deepClone();
}

