/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.executions;

import com.jaspersoft.jasperserver.dto.executions.AbstractClientExecution;
import com.jaspersoft.jasperserver.dto.executions.ClientQueryParams;
import com.jaspersoft.jasperserver.dto.executions.validation.CheckInMemoryDataSourceType;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="queryExecution")
@XmlType(propOrder={"query"})
public class ClientICQueryExecution
extends AbstractClientExecution<ClientICQueryExecution> {
    @NotNull
    @CheckInMemoryDataSourceType
    private ClientReferenceable query;
    private String selectedField;
    private String[] visibleFields;
    private boolean format;

    public ClientICQueryExecution() {
    }

    public ClientICQueryExecution(ClientICQueryExecution source) {
        super(source);
        this.query = ValueObjectUtils.copyOf(source.getQuery());
        this.selectedField = source.getSelectedField();
        this.visibleFields = Arrays.copyOf(source.getVisibleFields(), source.getVisibleFields().length);
        this.format = this.isFormat();
    }

    public ClientICQueryExecution(ClientReferenceable query, ClientReferenceable dataSource) {
        this.setQuery(query);
        this.setDataSource(dataSource);
    }

    public ClientICQueryExecution(String queryUri, String dataSourceUri) {
        this(new ClientReference(queryUri), new ClientReference(dataSourceUri));
    }

    @Override
    public ClientQueryParams getParams() {
        return super.getParams();
    }

    public String getSelectedField() {
        return this.selectedField;
    }

    public ClientICQueryExecution setSelectedField(String selectedField) {
        this.selectedField = selectedField;
        return this;
    }

    public String[] getVisibleFields() {
        return this.visibleFields;
    }

    public ClientICQueryExecution setVisibleFields(String[] visibleFields) {
        this.visibleFields = visibleFields;
        return this;
    }

    public boolean isFormat() {
        return this.format;
    }

    public ClientICQueryExecution setFormat(boolean format) {
        this.format = format;
        return this;
    }

    @XmlElement(type=ClientReference.class, name="reference")
    public ClientReferenceable getQuery() {
        return this.query;
    }

    public ClientICQueryExecution setQuery(ClientReferenceable query) {
        this.query = query;
        return this;
    }

    @Override
    public ClientICQueryExecution deepClone() {
        return new ClientICQueryExecution(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientICQueryExecution)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientICQueryExecution that = (ClientICQueryExecution)o;
        return this.format == that.format && Objects.equals(this.query, that.query) && Objects.equals(this.selectedField, that.selectedField) && Arrays.equals(this.visibleFields, that.visibleFields);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.query, this.selectedField, this.format);
        result = 31 * result + Arrays.hashCode(this.visibleFields);
        return result;
    }

    @Override
    public String toString() {
        return "ClientICQueryExecution{query=" + this.query + ", selectedField='" + this.selectedField + '\'' + ", visibleFields='" + this.visibleFields + '\'' + ", format='" + this.format + '\'' + "} " + super.toString();
    }
}

