/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.executions;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.executions.ClientQueryParams;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import javax.xml.bind.annotation.XmlElement;

public abstract class ClientQueryResultData<T extends ClientQueryResultData<T, DataSet, TotalCounts>, DataSet, TotalCounts>
implements DeepCloneable<ClientQueryResultData<T, DataSet, TotalCounts>> {
    protected TotalCounts totalCounts;
    protected DataSet dataSet;
    protected ClientQueryParams queryParams;
    private boolean truncated = false;

    public ClientQueryResultData() {
    }

    public ClientQueryResultData(ClientQueryResultData<T, DataSet, TotalCounts> source) {
        ValueObjectUtils.checkNotNull(source);
        this.setTotalCounts(this.deepCopyOfTotalCounts(source.getTotalCounts()));
        this.setDataSet(this.deepCopyOfDataSet(source.getDataSet()));
        this.queryParams = ValueObjectUtils.copyOf(source.getQueryParams());
        this.truncated = source.getTruncated();
    }

    protected abstract TotalCounts deepCopyOfTotalCounts(TotalCounts var1);

    protected abstract DataSet deepCopyOfDataSet(DataSet var1);

    public abstract DataSet getDataSet();

    protected abstract T setDataSet(DataSet var1);

    @XmlElement(name="params")
    public ClientQueryParams getQueryParams() {
        return this.queryParams;
    }

    public T setQueryParams(ClientQueryParams queryParams) {
        this.queryParams = queryParams;
        return (T)this;
    }

    protected abstract TotalCounts getTotalCounts();

    protected abstract T setTotalCounts(TotalCounts var1);

    public Boolean getTruncated() {
        return this.truncated;
    }

    public T setTruncated(Boolean truncated) {
        this.truncated = truncated != null ? truncated : false;
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientQueryResultData that = (ClientQueryResultData)o;
        if (this.getDataSet() != null ? !this.getDataSet().equals(that.getDataSet()) : that.getDataSet() != null) {
            return false;
        }
        if (this.queryParams != null ? !this.queryParams.equals(that.queryParams) : that.queryParams != null) {
            return false;
        }
        if (this.getTotalCounts() != null ? !this.getTotalCounts().equals(that.getTotalCounts()) : that.getTotalCounts() != null) {
            return false;
        }
        return this.truncated == that.truncated;
    }

    public int hashCode() {
        int result = this.getDataSet() != null ? this.getDataSet().hashCode() : 0;
        result = 31 * result + (this.queryParams != null ? this.queryParams.hashCode() : 0);
        result = 31 * result + (this.getTotalCounts() != null ? this.getTotalCounts().hashCode() : 0);
        result = 31 * result + (this.truncated ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ClientQueryResultData{totalCounts=" + this.totalCounts + ", dataSet=" + this.dataSet + ", queryParams=" + this.queryParams + ", truncated=" + this.truncated + '}';
    }
}

