/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.executions;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.executions.ExecutionStatus;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="pageStatus")
public class ExecutionPageStatusObject
implements DeepCloneable<ExecutionPageStatusObject> {
    private Boolean pageFinal;
    private Long pageTimestamp;
    private ExecutionStatus reportStatus;
    private ErrorDescriptor errorDescriptor;

    public ExecutionPageStatusObject() {
    }

    public ExecutionPageStatusObject(ExecutionPageStatusObject source) {
        ValueObjectUtils.checkNotNull(source);
        this.pageFinal = source.getPageFinal();
        this.pageTimestamp = source.getPageTimestamp();
        this.reportStatus = source.getReportStatus();
        this.errorDescriptor = ValueObjectUtils.copyOf(source.getErrorDescriptor());
    }

    public Boolean getPageFinal() {
        return this.pageFinal;
    }

    public ExecutionPageStatusObject setPageFinal(Boolean pageFinal) {
        this.pageFinal = pageFinal;
        return this;
    }

    public Long getPageTimestamp() {
        return this.pageTimestamp;
    }

    public ExecutionPageStatusObject setPageTimestamp(Long pageTimestamp) {
        this.pageTimestamp = pageTimestamp;
        return this;
    }

    public ExecutionStatus getReportStatus() {
        return this.reportStatus;
    }

    public ExecutionPageStatusObject setReportStatus(ExecutionStatus reportStatus) {
        this.reportStatus = reportStatus;
        return this;
    }

    public ErrorDescriptor getErrorDescriptor() {
        return this.errorDescriptor;
    }

    public ExecutionPageStatusObject setErrorDescriptor(ErrorDescriptor errorDescriptor) {
        this.errorDescriptor = errorDescriptor;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionPageStatusObject that = (ExecutionPageStatusObject)o;
        if (this.errorDescriptor != null ? !this.errorDescriptor.equals(that.errorDescriptor) : that.errorDescriptor != null) {
            return false;
        }
        if (this.pageFinal != that.pageFinal) {
            return false;
        }
        if (this.pageTimestamp != that.pageTimestamp) {
            return false;
        }
        return this.reportStatus == that.reportStatus;
    }

    public int hashCode() {
        int result = this.reportStatus != null ? this.reportStatus.hashCode() : 0;
        result = 31 * result + (this.pageFinal != null ? this.pageFinal.hashCode() : 0);
        result = 31 * result + (this.pageTimestamp != null ? this.pageTimestamp.hashCode() : 0);
        result = 31 * result + (this.errorDescriptor != null ? this.errorDescriptor.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ReportExecutionPageStatusObject{pageFinal=" + this.pageFinal + ", pageTimestamp=" + this.pageTimestamp + ", reportStatus=" + (Object)((Object)this.reportStatus) + ", errorDescriptor=" + this.errorDescriptor + '}';
    }

    @Override
    public ExecutionPageStatusObject deepClone() {
        return new ExecutionPageStatusObject(this);
    }
}

