/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.executions;

import com.jaspersoft.jasperserver.dto.common.CommonErrorCode;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptorTemplate;
import java.util.HashMap;
import java.util.Map;

public enum QueryExecutionsErrorCode implements ErrorDescriptorTemplate
{
    QUERY_EXECUTION_NOT_FOUND("query.execution.not.found", CommonErrorCode.paramNames("executionID")),
    QUERY_EXECUTION_REJECTED("query.execution.rejected", CommonErrorCode.paramNames("executionID")),
    QUERY_DATASOURCE_NOT_FOUND("query.datasource.not.found", CommonErrorCode.paramNames("dataSourceURI")),
    QUERY_DATASOURCE_TYPE_NOT_SUPPORTED("query.datasource.type.not.supported", CommonErrorCode.paramNames("dataSourceURI")),
    QUERY_DATASOURCE_ACCESS_DENIED("query.datasource.access.denied", CommonErrorCode.paramNames("dataSourceURI")),
    QUERY_IN_MEMORY_DATASOURCE_TYPE_NOT_SUPPORTED("query.in.memory.datasource.type.not.supported", CommonErrorCode.paramNames("propertyPath", "dataSourceType")),
    QUERY_FILTER_IS_NOT_VALID("query.filter.is.not.valid", CommonErrorCode.paramNames("invalidFilterExpression")),
    DATASOURCE_CONNECTION_FIELD("datasource.connection.failed", null),
    CALCULATED_FIELD_EXPRESSION_EVALUATION_ERROR("calculated.field.expression.evaluation.error", CommonErrorCode.paramNames("fieldExpression", "fieldName", "detailMessage")),
    QUERY_EXECUTION_CANCELLED("query.execution.cancelled", CommonErrorCode.paramNames("executionID")),
    QUERY_METADATA_FIELDS_NOT_FOUND("query.metadata.fields.not.found", CommonErrorCode.paramNames("fieldsNotFound")),
    QUERY_DATASOURCE_INVALID("query.datasource.invalid", CommonErrorCode.paramNames("dataSourceURI")),
    QUERY_AGGREGATE_DEFINITION_ERROR("query.aggregate.definition.error", CommonErrorCode.paramNames("propertyPath")),
    QUERY_FIELD_IDS_COLLISION("query.field.ids.collision", CommonErrorCode.paramNames("queryFieldIDs")),
    QUERY_FIELD_IDS_METADATA_FIELD_COLLISION("query.field.ids.metadata.field.collision", CommonErrorCode.paramNames("queryFieldIDs")),
    QUERY_FIELDS_FROM_MULTIPLE_DATAISLANDS("query.fields.from.multiple.dataislands", CommonErrorCode.paramNames("firstFieldID", "secondFieldID")),
    QUERY_DATASOURCE_OLAP_VIEW_NOT_SUPPORTED("query.datasource.olap.view.not.supported", CommonErrorCode.paramNames("dataSourceURI")),
    QUERY_EXPRESSION_OPERANDS_SIZE_OF_BOUND("query.expression.operands.size.out.of.bound", CommonErrorCode.paramNames("propertyPath", "minSize", "maxSize")),
    QUERY_WHERE_EXPRESSION_TYPE_NOT_SUPPORTED("query.where.expression.type.not.supported", CommonErrorCode.paramNames("expressionType")),
    QUERY_AGGREGATION_EXPRESSION_NOT_VALID("query.aggregation.expression.not.valid", CommonErrorCode.paramNames("expressionType")),
    QUERY_CALCULATED_FIELD_EXPRESSION_NOT_VALID("query.calculated.field.expression.not.valid", CommonErrorCode.paramNames("expressionType")),
    QUERY_FIELD_EXPRESSION_NOT_VALID("query.field.expression.not.valid", CommonErrorCode.paramNames("propertyPath", "expressionName")),
    QUERY_AGGREGATE_EXPRESSION_NOT_VALID("query.aggregate.expression.not.valid", CommonErrorCode.paramNames("propertyPath", "expressionName")),
    QUERY_AGGREGATION_FUNCTION_NAME_NOT_VALID("query.aggregation.function.name.not.valid", CommonErrorCode.paramNames("propertyPath", "aggregationFunction")),
    QUERY_GROUPBY_ALLGROUP_NOT_FIRST("query.groupBy.allGroup.not.first", CommonErrorCode.paramNames("propertyPath")),
    QUERY_GROUPBY_CATEGORIZER_NOT_VALID("query.groupBy.categorizer.not.valid", CommonErrorCode.paramNames("invalidCategorizerName")),
    QUERY_MULTI_AXIS_AGGREGATION_IS_EMPTY("query.multiAxis.aggregation.is.empty", null),
    QUERY_INVALID_STRUCTURE("query.invalid.structure", null),
    QUERY_ORDERBY_TOP_OR_BOTTOM_LIMIT_NOT_VALID("query.orderBy.topOrBottom.limit.not.valid", CommonErrorCode.paramNames("propertyPath", "invalidLimitValue")),
    QUERY_WHERE_PARAMETERS_EXPRESSION_NOT_VALID("query.where.parameters.expression.not.valid", null),
    QUERY_DETAILS_UNSUPPORTED("query.details.unsupported", null),
    QUERY_TRANSFORMATION_TOPN_NOT_ALLOWED_AGGREGATIONS_IN_ROWS("query.transformation.topn.not.allowed.aggregations.in.rows", null),
    EXPRESSION_REPRESENTATION_REQUIRED("expression.representation.required", CommonErrorCode.paramNames("propertyPath")),
    QUERY_TIMEBALANCE_INVALID_AGGREGATE_FUNCTION("query.timebalance.invalid.aggregate.function", CommonErrorCode.paramNames("queryFieldID")),
    QUERY_TIMEBALANCE_NO_DATE_FIELD("query.timebalance.no.datefield", CommonErrorCode.paramNames("queryFieldID")),
    QUERY_TIMEBALANCE_CANNOT_BE_APPLIED("query.timebalance.cannot.be.applied", CommonErrorCode.paramNames("queryFieldID", "invalidType")),
    QUERY_TIMEBALANCE_MULTIPLE_DATE_FIELD("query.timebalance.multiple.datefield", CommonErrorCode.paramNames("queryFieldID")),
    QUERY_FIELD_AGGREGATE_FUNCTION_IS_UNKNOWN("query.field.aggregate.function.is.unknown", CommonErrorCode.paramNames("aggregationFieldID", "invalidAggregationFunction")),
    QUERY_FIELD_AGGREGATE_EXPRESSION_PARSE_ERROR("query.field.aggregate.expression.parse.error", CommonErrorCode.paramNames("aggregationFieldID", "invalidAggregationExpression", "errorMessage")),
    QUERY_FIELD_EXPRESSION_PARSE_ERROR("query.field.expression.parse.error", CommonErrorCode.paramNames("fieldID", "invalidFieldExpression", "errorMessage")),
    QUERY_ORDERBY_LEVEL_REFERENCE_NOT_VALID("query.orderBy.level.reference.not.valid", CommonErrorCode.paramNames("propertyPath")),
    QUERY_LIMT_OUT_OF_RANGE("query.limit.out.of.range", CommonErrorCode.paramNames("minQueryLimit", "maxQueryLimit")),
    QUERY_WHERE_PARAMETERS_EXPRESSION_TYPE_NOT_VALID("query.where.parameters.expression.type.not.valid", CommonErrorCode.paramNames("invalidParameterNames", "operator", "parameterTypes")),
    PAGING_AXIS_COUNT_OUT_OF_RANGE("paging.axis.count.out.of.range", null),
    PAGING_OFFSET_OUT_OF_RANGE("paging.offset.out.of.range", CommonErrorCode.paramNames("startRange", "endRange")),
    PAGING_PAGE_SIZE_OUT_OF_RANGE("paging.page.size.out.of.range", CommonErrorCode.paramNames("minPageSize")),
    PARAMETER_NAME_IN_NOT_VALID("query.where.parameters.name.is.not.valid", null),
    FIELD_OR_MEASURE_IS_NOT_FOUND("field.or.measure.is.not.found", CommonErrorCode.paramNames("fieldName", "measureName")),
    FIELD_NAME_IS_NULL("field.name.is.null", null),
    FIELD_IS_NOT_FOUND("field.is.not.found", CommonErrorCode.paramNames("fieldName")),
    CALC_FIELD_IS_NOT_FOUND("calc.field.is.not.found", CommonErrorCode.paramNames("fieldName")),
    CALC_FIELD_EXPRESSION_IS_NULL("calc.field.expression.is.null", CommonErrorCode.paramNames("fieldName", "fieldExpression")),
    CALC_FIELD_EXPRESSION_PARSE_ERROR("calc.field.expression.parse.error", CommonErrorCode.paramNames("fieldName", "fieldExpression", "errorMessage")),
    CALC_FIELD_AGGREGATE_EXPRESSION_IS_INVALID("calc.field.aggregate.expression.is.invalid", CommonErrorCode.paramNames("fieldID", "invalidAggregationExpression")),
    CALC_FIELD_IS_MISSING_KIND_PROPERTY("calc.field.is.missing.kind.property", CommonErrorCode.paramNames("fieldID")),
    ADHOC_FIELD_AGGREGATE_FUNCTION_AGGREGATE_FORMULA_IS_NOT_APPLICABLE("query.field.aggregate.function.aggregate.formula.is.not.applicable", CommonErrorCode.paramNames("fieldID", "invalidAggregationFunction")),
    ADHOC_FIELD_AGGREGATE_EXPRESSION_IS_NULL("query.field.aggregate.expression.is.null", CommonErrorCode.paramNames("fieldID", "invalidAggregationFunction")),
    SORT_FIELD_HAS_BAD_FIELD_OR_MEASURE_NAME("sort.field.has.bad.field.or.measure.name", CommonErrorCode.paramNames("fieldNumber", "fieldCount")),
    SORT_FIELD_HAS_BAD_MEASURE_INDEX("sort.field.has.bad.measure.index", CommonErrorCode.paramNames("fieldName", "measureIndex")),
    MEASURE_HAS_BAD_NAME("measure.has.bad.name", CommonErrorCode.paramNames("measureNumber", "measureCount")),
    MEASURE_IS_NOT_FOUND("measure.is.not.found", CommonErrorCode.paramNames("measureID")),
    FILTER_VALIDATION_ERROR("filter.validation.error", null),
    EXPRESSION_IS_INVALID("expression.is.invalid", CommonErrorCode.paramNames("fieldID", "fieldExpression", "errorMessage")),
    EXPRESSION_HAS_UNDECLARED_VARIABLE("expression.has.undeclared.variable", CommonErrorCode.paramNames("expression", "expression")),
    MULTI_AXIS_QUERY_IS_MISSING_ROW_AXIS("multi.axis.query.is.missing.row.axis", null),
    MULTI_AXIS_QUERY_IS_MISSING_COLUMN_AXIS("multi.axis.query.is.missing.column.axis", null),
    MULTI_AXIS_QUERY_AXIS_HAS_WRONG_TYPE("multi.axis.query.axis.has.wrong.type", CommonErrorCode.paramNames("axisName", "axisType")),
    MULTI_AXIS_QUERY_IS_MISSING_DIMENSION("multi.axis.query.is.missing.dimension", CommonErrorCode.paramNames("axisName", "dimensionNumber", "dimensionCount")),
    MULTI_AXIS_QUERY_HAS_BAD_FIELD("multi.axis.query.has.bad.field", CommonErrorCode.paramNames("axisName", "dimensionNumber", "dimensionCount")),
    MULTI_AXIS_QUERY_ADHOC_DIMENSION_HAS_MULTIPLE_LEVELS("multi.axis.query.adhoc.dimension.has.multiple.levels", CommonErrorCode.paramNames("axisName", "dimensionNumber", "dimensionCount", "dimensionLevelCount")),
    MULTI_AXIS_QUERY_ADHOC_DIMENSION_HAS_NO_LEVELS("multi.axis.query.adhoc.dimension.has.no.levels", CommonErrorCode.paramNames("axisName", "dimensionNumber", "dimensionCount")),
    MULTI_AXIS_QUERY_DIMENSION_HAS_MULTIPLE_LEVELS("multi.axis.query.dimension.has.multiple.levels", CommonErrorCode.paramNames("axisName", "dimensionNumber", "dimensionCount", "dimensionLevelCount")),
    MULTI_AXIS_QUERY_DIMENSION_HAS_NO_LEVELS("multi.axis.query.dimension.has.no.levels", CommonErrorCode.paramNames("axisName", "dimensionNumber", "dimensionCount", "dimensionLevelCount")),
    MULTI_AXIS_QUERY_DIMENSION_HAS_BAD_UNIQUE_NAME("multi.axis.query.dimension.has.bad.unique.name", CommonErrorCode.paramNames("axisName", "dimensionNumber", "dimensionCount", "fieldUniqueName")),
    MULTI_AXIS_QUERY_DIMENSION_HAS_BAD_LEVEL_NAME("multi.axis.query.dimension.has.bad.level.name", CommonErrorCode.paramNames("axisName", "dimensionNumber", "dimensionCount", "fieldUniqueName")),
    MULTI_LEVEL_QUERY_MEASURE_HAS_WRONG_TYPE("multi.level.query.measure.has.wrong.type", CommonErrorCode.paramNames("fieldType")),
    FLAT_QUERY_GROUP_BY_HAS_WRONG_TYPE("flat.query.group.by.has.wrong.type", CommonErrorCode.paramNames("fieldType")),
    FLAT_QUERY_MEASURE_HAS_WRONG_TYPE("flat.query.measure.has.wrong.type", CommonErrorCode.paramNames("fieldType")),
    PARAMETER_NAME_METADATA_FIELD_COLLISION_ERROR("query.parameter.name.metadata.field.collision", CommonErrorCode.paramNames("metadataFieldNamesCollisionParams")),
    PATH_NOT_INCLUDE_ALL_MEMBERS("transformation.path.not.include.all.members", CommonErrorCode.paramNames("invalidTransformationPath", "availableTransformationPaths")),
    QUERY_LEVEL_EXPANSION_AMBIGUOUS_REFERENCE("query.expansion.level.ambiguous.reference.error", CommonErrorCode.paramNames("ambiguousRefs")),
    QUERY_EXPANSION_LEVEL_REFERENCE_NOT_VALID("query.expansion.level.reference.not.valid", CommonErrorCode.paramNames("reference")),
    QUERY_PARAMETER_NAME_QUERY_FIELD_ID_COLLISION_ERROR("query.parameter.name.query.field.id.collision", CommonErrorCode.paramNames("duplicatedIds")),
    QUERY_REFERENCE_INTEGRITY_ERROR("query.reference.integrity.error", null),
    QUERY_FILTER_REFERENCE_CLASS_ERROR("query.filter.reference.class.error", CommonErrorCode.paramNames("fieldName", "unsupportedType")),
    QUERY_ORDER_GENERIC_REFERENCE_CLASS_ERROR("query.order.generic.reference.class.error", CommonErrorCode.paramNames("fieldName", "unsupportedType")),
    QUERY_ORDER_HEADER_NULL_REFERENCE_ERROR("query.order.header.null.reference.error", null),
    QUERY_ORDER_HEADER_REFERENCE_CLASS_ERROR("query.order.header.reference.class.error", CommonErrorCode.paramNames("fieldName", "unsupportedType")),
    QUERY_EXPANSION_HEADER_NULL_REFERENCE_ERROR("query.expansion.header.null.reference.error", null),
    QUERY_EXPANSION_LEVEL_REFERENCE_CLASS_ERROR("query.expansion.level.reference.class.error", CommonErrorCode.paramNames("fieldName", "unsupportedType")),
    QUERY_AGGREGATED_FIELD_REFERENCE_CLASS_ERROR("query.aggregated.field.reference.class.error", CommonErrorCode.paramNames("fieldName", "unsupportedType")),
    MULTIPLE_GROUP_BY_AGGREGATIONS("parameter.groupBy.multiple.aggregations.error", null),
    QUERY_SELECT_ILLEGAL_FIELDS_STATE("query.select.illegal.fields.state", null),
    QUERY_DISTINCT_FIELDS_AND_GROUP_BY_NOT_ALLOWED_FOR_CALCULATED_FIELD_WITH_AGGREGATE("query.distinctfields.and.groupBy.not.allowed.for.calcfield.with.aggregate", CommonErrorCode.paramNames("fieldID", "fieldExpression"));

    private String code;
    private String[] paramNames;
    private static final Map<String, QueryExecutionsErrorCode> stringToEnum;

    private QueryExecutionsErrorCode(String code, String[] paramNames) {
        this.code = code;
        this.paramNames = paramNames;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String[] getParamNames() {
        return this.paramNames;
    }

    @Override
    public ErrorDescriptor createDescriptor(Object ... propValues) {
        return new ErrorDescriptor().setErrorCode(this.code).setProperties(CommonErrorCode.buildProperties(this.paramNames, propValues));
    }

    public String toString() {
        return this.code;
    }

    public static ErrorDescriptor createDescriptorFrom(String code, Object ... propValues) {
        return QueryExecutionsErrorCode.createDescriptorFrom(code, null, propValues);
    }

    public static ErrorDescriptor createDescriptorFrom(String code, String message, Object[] propValues) {
        if (stringToEnum.get(code) == null) {
            throw new IllegalArgumentException("Ad Hoc query execution error code " + code + " is not defined");
        }
        return stringToEnum.get(code).createDescriptor(propValues).setMessage(message);
    }

    static {
        stringToEnum = new HashMap<String, QueryExecutionsErrorCode>();
        for (QueryExecutionsErrorCode code : QueryExecutionsErrorCode.values()) {
            stringToEnum.put(code.toString(), code);
        }
    }

    public static interface Codes {
        public static final String QUERY_EXECUTION_NOT_FOUND = "query.execution.not.found";
        public static final String QUERY_EXECUTION_REJECTED = "query.execution.rejected";
        public static final String QUERY_DATASOURCE_NOT_FOUND = "query.datasource.not.found";
        public static final String QUERY_DATASOURCE_TYPE_NOT_SUPPORTED = "query.datasource.type.not.supported";
        public static final String QUERY_DATASOURCE_ACCESS_DENIED = "query.datasource.access.denied";
        public static final String QUERY_IN_MEMORY_DATASOURCE_TYPE_NOT_SUPPORTED = "query.in.memory.datasource.type.not.supported";
        public static final String QUERY_FILTER_IS_NOT_VALID = "query.filter.is.not.valid";
        public static final String DATASOURCE_CONNECTION_FIELD = "datasource.connection.failed";
        public static final String CALCULATED_FIELD_EXPRESSION_EVALUATION_ERROR = "calculated.field.expression.evaluation.error";
        public static final String QUERY_EXECUTION_CANCELLED = "query.execution.cancelled";
        public static final String QUERY_METADATA_FIELDS_NOT_FOUND = "query.metadata.fields.not.found";
        public static final String QUERY_DATASOURCE_INVALID = "query.datasource.invalid";
        public static final String QUERY_AGGREGATE_DEFINITION_ERROR = "query.aggregate.definition.error";
        public static final String QUERY_FIELD_IDS_COLLISION = "query.field.ids.collision";
        public static final String QUERY_FIELD_IDS_METADATA_FIELD_COLLISION = "query.field.ids.metadata.field.collision";
        public static final String QUERY_FIELDS_FROM_MULTIPLE_DATAISLANDS = "query.fields.from.multiple.dataislands";
        public static final String QUERY_DATASOURCE_OLAP_VIEW_NOT_SUPPORTED = "query.datasource.olap.view.not.supported";
        public static final String QUERY_EXPRESSION_OPERANDS_SIZE_OF_BOUND = "query.expression.operands.size.out.of.bound";
        public static final String QUERY_WHERE_EXPRESSION_TYPE_NOT_SUPPORTED = "query.where.expression.type.not.supported";
        public static final String QUERY_AGGREGATION_EXPRESSION_NOT_VALID = "query.aggregation.expression.not.valid";
        public static final String QUERY_CALCULATED_FIELD_EXPRESSION_NOT_VALID = "query.calculated.field.expression.not.valid";
        public static final String QUERY_AGGREGATE_EXPRESSION_NOT_VALID = "query.aggregate.expression.not.valid";
        public static final String QUERY_FIELD_EXPRESSION_NOT_VALID = "query.field.expression.not.valid";
        public static final String QUERY_AGGREGATION_FUNCTION_NAME_NOT_VALID = "query.aggregation.function.name.not.valid";
        public static final String QUERY_GROUPBY_ALLGROUP_NOT_FIRST = "query.groupBy.allGroup.not.first";
        public static final String QUERY_GROUPBY_CATEGORIZER_NOT_VALID = "query.groupBy.categorizer.not.valid";
        public static final String QUERY_MULTI_AXIS_AGGREGATION_IS_EMPTY = "query.multiAxis.aggregation.is.empty";
        public static final String QUERY_INVALID_STRUCTURE = "query.invalid.structure";
        public static final String QUERY_ORDERBY_TOP_OR_BOTTOM_LIMIT_NOT_VALID = "query.orderBy.topOrBottom.limit.not.valid";
        public static final String QUERY_WHERE_PARAMETERS_EXPRESSION_NOT_VALID = "query.where.parameters.expression.not.valid";
        public static final String QUERY_DETAILS_UNSUPPORTED = "query.details.unsupported";
        public static final String QUERY_TRANSFORMATION_TOPN_NOT_ALLOWED_AGGREGATIONS_IN_ROWS = "query.transformation.topn.not.allowed.aggregations.in.rows";
        public static final String EXPRESSION_REPRESENTATION_REQUIRED = "expression.representation.required";
        public static final String QUERY_ORDERBY_LEVEL_REFERENCE_NOT_VALID = "query.orderBy.level.reference.not.valid";
        public static final String QUERY_LIMT_OUT_OF_RANGE = "query.limit.out.of.range";
        public static final String PAGING_AXIS_COUNT_OUT_OF_RANGE = "paging.axis.count.out.of.range";
        public static final String PAGING_OFFSET_OUT_OF_RANGE = "paging.offset.out.of.range";
        public static final String PAGING_PAGE_SIZE_OUT_OF_RANGE = "paging.page.size.out.of.range";
        public static final String QUERY_TIMEBALANCE_INVALID_AGGREGATE_FUNCTION = "query.timebalance.invalid.aggregate.function";
        public static final String QUERY_TIMEBALANCE_NO_DATE_FIELD = "query.timebalance.no.datefield";
        public static final String QUERY_TIMEBALANCE_CANNOT_BE_APPLIED = "query.timebalance.cannot.be.applied";
        public static final String QUERY_TIMEBALANCE_MULTIPLE_DATE_FIELD = "query.timebalance.multiple.datefield";
        public static final String QUERY_FIELD_AGGREGATE_FUNCTION_IS_UNKNOWN = "query.field.aggregate.function.is.unknown";
        public static final String QUERY_FIELD_EXPRESSION_PARSE_ERROR = "query.field.expression.parse.error";
        public static final String QUERY_FIELD_AGGREGATE_EXPRESSION_PARSE_ERROR = "query.field.aggregate.expression.parse.error";
        public static final String QUERY_WHERE_PARAMETERS_NAME_IS_NOT_VALID = "query.where.parameters.name.is.not.valid";
        public static final String QUERY_WHERE_PARAMETERS_EXPRESSION_TYPE_NOT_VALID = "query.where.parameters.expression.type.not.valid";
        public static final String FIELD_OR_MEASURE_IS_NOT_FOUND = "field.or.measure.is.not.found";
        public static final String FIELD_NAME_IS_NULL = "field.name.is.null";
        public static final String FIELD_IS_NOT_FOUND = "field.is.not.found";
        public static final String CALC_FIELD_IS_NOT_FOUND = "calc.field.is.not.found";
        public static final String CALC_FIELD_EXPRESSION_IS_NULL = "calc.field.expression.is.null";
        public static final String CALC_FIELD_EXPRESSION_PARSE_ERROR = "calc.field.expression.parse.error";
        public static final String CALC_FIELD_AGGREGATE_EXPRESSION_IS_INVALID = "calc.field.aggregate.expression.is.invalid";
        public static final String CALC_FIELD_IS_MISSING_KIND_PROPERTY = "calc.field.is.missing.kind.property";
        public static final String ADHOC_FIELD_AGGREGATE_FUNCTION_AGGREGATE_FORMULA_IS_NOT_APPLICABLE = "query.field.aggregate.function.aggregate.formula.is.not.applicable";
        public static final String ADHOC_FIELD_AGGREGATE_EXPRESSION_IS_NULL = "query.field.aggregate.expression.is.null";
        public static final String SORT_FIELD_HAS_BAD_FIELD_OR_MEASURE_NAME = "sort.field.has.bad.field.or.measure.name";
        public static final String SORT_FIELD_HAS_BAD_MEASURE_INDEX = "sort.field.has.bad.measure.index";
        public static final String MEASURE_HAS_BAD_NAME = "measure.has.bad.name";
        public static final String MEASURE_IS_NOT_FOUND = "measure.is.not.found";
        public static final String TIMEBALANCE_CANNOT_REMOVE_DATEFIELD_ERROR = "query.timebalance.cannot.remove.datefield";
        public static final String FILTER_VALIDATION_ERROR = "filter.validation.error";
        public static final String EXPRESSION_IS_INVALID = "expression.is.invalid";
        public static final String EXPRESSION_HAS_UNDECLARED_VARIABLE = "expression.has.undeclared.variable";
        public static final String MULTI_AXIS_QUERY_IS_MISSING_ROW_AXIS = "multi.axis.query.is.missing.row.axis";
        public static final String MULTI_AXIS_QUERY_IS_MISSING_COLUMN_AXIS = "multi.axis.query.is.missing.column.axis";
        public static final String MULTI_AXIS_QUERY_AXIS_HAS_WRONG_TYPE = "multi.axis.query.axis.has.wrong.type";
        public static final String MULTI_AXIS_QUERY_IS_MISSING_DIMENSION = "multi.axis.query.is.missing.dimension";
        public static final String MULTI_AXIS_QUERY_HAS_BAD_FIELD = "multi.axis.query.has.bad.field";
        public static final String MULTI_AXIS_QUERY_ADHOC_DIMENSION_HAS_MULTIPLE_LEVELS = "multi.axis.query.adhoc.dimension.has.multiple.levels";
        public static final String MULTI_AXIS_QUERY_ADHOC_DIMENSION_HAS_NO_LEVELS = "multi.axis.query.adhoc.dimension.has.no.levels";
        public static final String MULTI_AXIS_QUERY_DIMENSION_HAS_MULTIPLE_LEVELS = "multi.axis.query.dimension.has.multiple.levels";
        public static final String MULTI_AXIS_QUERY_DIMENSION_HAS_NO_LEVELS = "multi.axis.query.dimension.has.no.levels";
        public static final String MULTI_AXIS_QUERY_DIMENSION_HAS_BAD_UNIQUE_NAME = "multi.axis.query.dimension.has.bad.unique.name";
        public static final String MULTI_AXIS_QUERY_DIMENSION_HAS_BAD_LEVEL_NAME = "multi.axis.query.dimension.has.bad.level.name";
        public static final String MULTI_LEVEL_QUERY_MEASURE_HAS_WRONG_TYPE = "multi.level.query.measure.has.wrong.type";
        public static final String FLAT_QUERY_GROUP_BY_HAS_WRONG_TYPE = "flat.query.group.by.has.wrong.type";
        public static final String FLAT_QUERY_MEASURE_HAS_WRONG_TYPE = "flat.query.measure.has.wrong.type";
        public static final String PARAMETER_NAME_METADATA_FIELD_COLLISION_ERROR = "query.parameter.name.metadata.field.collision";
        public static final String PATH_NOT_INCLUDE_ALL_MEMBERS = "transformation.path.not.include.all.members";
        public static final String QUERY_LEVEL_EXPANSION_AMBIGUOUS_REFERENCE = "query.expansion.level.ambiguous.reference.error";
        public static final String QUERY_EXPANSION_LEVEL_REFERENCE_NOT_VALID = "query.expansion.level.reference.not.valid";
        public static final String QUERY_PARAMETER_NAME_QUERY_FIELD_ID_COLLISION_ERROR = "query.parameter.name.query.field.id.collision";
        public static final String QUERY_REFERENCE_INTEGRITY_ERROR = "query.reference.integrity.error";
        public static final String QUERY_FILTER_REFERENCE_CLASS_ERROR = "query.filter.reference.class.error";
        public static final String QUERY_ORDER_GENERIC_REFERENCE_CLASS_ERROR = "query.order.generic.reference.class.error";
        public static final String QUERY_ORDER_HEADER_NULL_REFERENCE_ERROR = "query.order.header.null.reference.error";
        public static final String QUERY_ORDER_HEADER_REFERENCE_CLASS_ERROR = "query.order.header.reference.class.error";
        public static final String QUERY_EXPANSION_HEADER_NULL_REFERENCE_ERROR = "query.expansion.header.null.reference.error";
        public static final String QUERY_EXPANSION_LEVEL_REFERENCE_CLASS_ERROR = "query.expansion.level.reference.class.error";
        public static final String QUERY_AGGREGATED_FIELD_REFERENCE_CLASS_ERROR = "query.aggregated.field.reference.class.error";
        public static final String MULTIPLE_GROUP_BY_AGGREGATIONS = "parameter.groupBy.multiple.aggregations.error";
        public static final String QUERY_SELECT_ILLEGAL_FIELDS_STATE = "query.select.illegal.fields.state";
        public static final String QUERY_DISTINCT_FIELDS_AND_GROUP_BY_NOT_ALLOWED_OVER_CALCULATED_FIELD_WITH_AGGREGATE = "query.distinctfields.and.groupBy.not.allowed.for.calcfield.with.aggregate";
    }
}

