/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.executions.validation;

import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.ValidationErrorDescriptorBuilder;
import com.jaspersoft.jasperserver.dto.executions.QueryExecutionsErrorCode;
import com.jaspersoft.jasperserver.dto.executions.validation.CheckInMemoryDataSourceType;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceable;
import com.jaspersoft.jasperserver.dto.resources.domain.ClientDomain;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ConstraintViolation;
import javax.xml.bind.annotation.XmlRootElement;

public class CheckInMemoryDataSourceTypeValidator
implements ConstraintValidator<CheckInMemoryDataSourceType, ClientReferenceable>,
ValidationErrorDescriptorBuilder {
    private final Set<Class<?>> supportedDatasourceClazzAndNameMap = new HashSet<Class<?>>(){
        {
            this.add(ClientReference.class);
            this.add(ClientDomain.class);
        }
    };

    public void initialize(CheckInMemoryDataSourceType constraintAnnotation) {
    }

    public boolean isValid(ClientReferenceable value, ConstraintValidatorContext context) {
        return value == null || this.supportedDatasourceClazzAndNameMap.contains(value.getClass());
    }

    public ErrorDescriptor build(ConstraintViolation violation) {
        String dataSourceName = this.getClientResourceName(violation.getInvalidValue().getClass());
        return QueryExecutionsErrorCode.QUERY_IN_MEMORY_DATASOURCE_TYPE_NOT_SUPPORTED.createDescriptor(violation.getPropertyPath().toString(), dataSourceName);
    }

    private String getClientResourceName(Class<?> clazz) {
        XmlRootElement xmlRootElement = clazz.getAnnotation(XmlRootElement.class);
        return xmlRootElement.name();
    }
}

