/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.importexport;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="export")
public class ExportTask
implements DeepCloneable<ExportTask> {
    private List<String> exportParams;
    private List<String> urisOfResources;
    private List<String> rolesToExport;
    private List<String> usersToExport;
    private List<String> resourceTypes;
    private String organization;
    private String keyAlias;
    @XmlTransient
    private List<String> urisOfScheduledJobs;

    public ExportTask() {
    }

    public ExportTask(ExportTask other) {
        ValueObjectUtils.checkNotNull(other);
        this.exportParams = ValueObjectUtils.copyOf(other.getParameters());
        this.urisOfResources = ValueObjectUtils.copyOf(other.getUris());
        this.urisOfScheduledJobs = ValueObjectUtils.copyOf(other.getScheduledJobs());
        this.rolesToExport = ValueObjectUtils.copyOf(other.getRoles());
        this.usersToExport = ValueObjectUtils.copyOf(other.getUsers());
        this.resourceTypes = ValueObjectUtils.copyOf(other.getResourceTypes());
        this.organization = other.getOrganization();
        this.keyAlias = other.getKeyAlias();
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public List<String> getParameters() {
        return this.exportParams;
    }

    public ExportTask setParameters(List<String> exportParams) {
        this.exportParams = exportParams;
        return this;
    }

    @XmlElementWrapper(name="uris")
    @XmlElement(name="uri")
    public List<String> getUris() {
        return this.urisOfResources;
    }

    public ExportTask setUris(List<String> urisOfResources) {
        this.urisOfResources = urisOfResources;
        return this;
    }

    public List<String> getScheduledJobs() {
        return this.urisOfScheduledJobs;
    }

    public ExportTask setScheduledJobs(List<String> urisOfScheduledJobs) {
        this.urisOfScheduledJobs = urisOfScheduledJobs;
        return this;
    }

    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    public List<String> getRoles() {
        return this.rolesToExport;
    }

    public ExportTask setRoles(List<String> rolesToExport) {
        this.rolesToExport = rolesToExport;
        return this;
    }

    @XmlElementWrapper(name="users")
    @XmlElement(name="user")
    public List<String> getUsers() {
        return this.usersToExport;
    }

    public ExportTask setUsers(List<String> usersToExport) {
        this.usersToExport = usersToExport;
        return this;
    }

    @XmlElement(name="organization")
    public String getOrganization() {
        return this.organization;
    }

    public ExportTask setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    @XmlElementWrapper(name="resourceTypes")
    @XmlElement(name="resourceType")
    public List<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public ExportTask setResourceTypes(List<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    @XmlElement(name="keyAlias")
    public String getKeyAlias() {
        return this.keyAlias;
    }

    public ExportTask setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportTask)) {
            return false;
        }
        ExportTask that = (ExportTask)o;
        if (this.exportParams != null ? !this.exportParams.equals(that.exportParams) : that.exportParams != null) {
            return false;
        }
        if (this.keyAlias != null ? !this.keyAlias.equals(that.keyAlias) : that.keyAlias != null) {
            return false;
        }
        if (this.urisOfResources != null ? !this.urisOfResources.equals(that.urisOfResources) : that.urisOfResources != null) {
            return false;
        }
        if (this.urisOfScheduledJobs != null ? !this.urisOfScheduledJobs.equals(that.urisOfScheduledJobs) : that.urisOfScheduledJobs != null) {
            return false;
        }
        if (this.rolesToExport != null ? !this.rolesToExport.equals(that.rolesToExport) : that.rolesToExport != null) {
            return false;
        }
        if (this.usersToExport != null ? !this.usersToExport.equals(that.usersToExport) : that.usersToExport != null) {
            return false;
        }
        if (this.getResourceTypes() != null ? !this.getResourceTypes().equals(that.getResourceTypes()) : that.getResourceTypes() != null) {
            return false;
        }
        return !(this.getOrganization() == null ? that.getOrganization() != null : !this.getOrganization().equals(that.getOrganization()));
    }

    public int hashCode() {
        int result = this.exportParams != null ? this.exportParams.hashCode() : 0;
        result = 31 * result + (this.urisOfResources != null ? this.urisOfResources.hashCode() : 0);
        result = 31 * result + (this.urisOfScheduledJobs != null ? this.urisOfScheduledJobs.hashCode() : 0);
        result = 31 * result + (this.rolesToExport != null ? this.rolesToExport.hashCode() : 0);
        result = 31 * result + (this.usersToExport != null ? this.usersToExport.hashCode() : 0);
        result = 31 * result + (this.getResourceTypes() != null ? this.getResourceTypes().hashCode() : 0);
        result = 31 * result + (this.getOrganization() != null ? this.getOrganization().hashCode() : 0);
        result = 31 * result + (this.keyAlias != null ? this.keyAlias.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ExportTask{exportParams=" + this.exportParams + ", urisOfResources=" + this.urisOfResources + ", urisOfScheduledJobs=" + this.urisOfScheduledJobs + ", rolesToExport=" + this.rolesToExport + ", usersToExport=" + this.usersToExport + ", resourceTypes=" + this.resourceTypes + ", organization='" + this.organization + '\'' + ", keyAlias='" + this.keyAlias + '\'' + '}';
    }

    @Override
    public ExportTask deepClone() {
        return new ExportTask(this);
    }
}

