/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.importexport;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="import")
public class ImportTask
implements DeepCloneable<ImportTask> {
    private String organization;
    private String brokenDependencies;
    private List<String> parameters;
    private String keyAlias;
    private String secretKey;
    private String secretUri;

    public ImportTask() {
    }

    public ImportTask(ImportTask other) {
        ValueObjectUtils.checkNotNull(other);
        this.organization = other.getOrganization();
        this.brokenDependencies = other.getBrokenDependencies();
        this.parameters = ValueObjectUtils.copyOf(other.getParameters());
        this.keyAlias = other.getKeyAlias();
        this.secretKey = other.getSecretKey();
        this.secretUri = other.getSecretUri();
    }

    @XmlElement(name="organization")
    public String getOrganization() {
        return this.organization;
    }

    public ImportTask setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    @XmlElement(name="brokenDependencies")
    public String getBrokenDependencies() {
        return this.brokenDependencies;
    }

    public ImportTask setBrokenDependencies(String brokenDependencies) {
        this.brokenDependencies = brokenDependencies;
        return this;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public List<String> getParameters() {
        return this.parameters;
    }

    public ImportTask setParameters(List<String> parameters) {
        this.parameters = parameters;
        return this;
    }

    @XmlElement(name="keyAlias")
    public String getKeyAlias() {
        return this.keyAlias;
    }

    public ImportTask setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    @XmlElement(name="secretKey")
    public String getSecretKey() {
        return this.secretKey;
    }

    public ImportTask setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @XmlElement(name="secretUri")
    public String getSecretUri() {
        return this.secretUri;
    }

    public ImportTask setSecretUri(String secretUri) {
        this.secretUri = secretUri;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportTask)) {
            return false;
        }
        ImportTask that = (ImportTask)o;
        if (this.getOrganization() != null ? !this.getOrganization().equals(that.getOrganization()) : that.getOrganization() != null) {
            return false;
        }
        if (this.keyAlias != null ? !this.keyAlias.equals(that.getKeyAlias()) : that.getKeyAlias() != null) {
            return false;
        }
        if (this.secretKey != null ? !this.secretKey.equals(that.getSecretKey()) : that.getSecretKey() != null) {
            return false;
        }
        if (this.secretUri != null ? !this.secretUri.equals(that.getSecretUri()) : that.getSecretUri() != null) {
            return false;
        }
        if (this.getBrokenDependencies() != null ? !this.getBrokenDependencies().equals(that.getBrokenDependencies()) : that.getBrokenDependencies() != null) {
            return false;
        }
        return !(this.getParameters() == null ? that.getParameters() != null : !this.getParameters().equals(that.getParameters()));
    }

    public int hashCode() {
        int result = this.getOrganization() != null ? this.getOrganization().hashCode() : 0;
        result = 31 * result + (this.getBrokenDependencies() != null ? this.getBrokenDependencies().hashCode() : 0);
        result = 31 * result + (this.getParameters() != null ? this.getParameters().hashCode() : 0);
        result = 31 * result + (this.keyAlias != null ? this.keyAlias.hashCode() : 0);
        result = 31 * result + (this.secretKey != null ? this.secretKey.hashCode() : 0);
        result = 31 * result + (this.secretUri != null ? this.secretUri.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ImportTask{organization='" + this.organization + '\'' + ", brokenDependencies='" + this.brokenDependencies + '\'' + ", parameters=" + this.parameters + ", keyAlias='" + this.keyAlias + '\'' + ", secretUri='" + this.secretUri + '\'' + '}';
    }

    @Override
    public ImportTask deepClone() {
        return new ImportTask(this);
    }
}

