/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.importexport;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.common.ErrorDescriptor;
import com.jaspersoft.jasperserver.dto.common.WarningDescriptor;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="state")
public class State
implements DeepCloneable<State> {
    String id;
    String message;
    String phase;
    List<WarningDescriptor> warnings;
    ErrorDescriptor error;

    public State() {
    }

    public State(State other) {
        ValueObjectUtils.checkNotNull(other);
        this.id = other.getId();
        this.message = other.getMessage();
        this.phase = other.getPhase();
        this.warnings = ValueObjectUtils.copyOf(other.getWarnings());
        this.error = ValueObjectUtils.copyOf(other.getError());
    }

    @XmlElement(name="id")
    public synchronized String getId() {
        return this.id;
    }

    public synchronized State setId(String id) {
        this.id = id;
        return this;
    }

    @XmlElement(name="phase")
    public synchronized String getPhase() {
        return this.phase;
    }

    public synchronized State setPhase(String phase) {
        this.phase = phase;
        return this;
    }

    @XmlElement(name="message")
    public synchronized String getMessage() {
        return this.message;
    }

    public synchronized State setMessage(String message) {
        this.message = message;
        return this;
    }

    public synchronized State setWarnings(List<WarningDescriptor> warnings) {
        this.warnings = warnings;
        return this;
    }

    @XmlElement(name="warnings")
    public synchronized List<WarningDescriptor> getWarnings() {
        if (this.warnings != null && this.warnings.size() > 0) {
            return this.warnings;
        }
        return null;
    }

    @XmlElement(name="error")
    public synchronized ErrorDescriptor getError() {
        if (this.error == null) {
            return null;
        }
        ErrorDescriptor errorDescriptor = new ErrorDescriptor(this.error);
        return errorDescriptor;
    }

    public synchronized State setError(ErrorDescriptor error) {
        this.error = error == null ? null : new ErrorDescriptor(error);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State state = (State)o;
        if (this.getId() != null ? !this.getId().equals(state.getId()) : state.getId() != null) {
            return false;
        }
        if (this.getMessage() != null ? !this.getMessage().equals(state.getMessage()) : state.getMessage() != null) {
            return false;
        }
        if (this.getPhase() != null ? !this.getPhase().equals(state.getPhase()) : state.getPhase() != null) {
            return false;
        }
        if (this.getWarnings() != null ? !this.getWarnings().equals(state.getWarnings()) : state.getWarnings() != null) {
            return false;
        }
        return !(this.getError() == null ? state.getError() != null : !this.getError().equals(state.getError()));
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getMessage() != null ? this.getMessage().hashCode() : 0);
        result = 31 * result + (this.getPhase() != null ? this.getPhase().hashCode() : 0);
        result = 31 * result + (this.getWarnings() != null ? this.getWarnings().hashCode() : 0);
        result = 31 * result + (this.getError() != null ? this.getError().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "State{id='" + this.id + '\'' + ", message='" + this.message + '\'' + ", phase='" + this.phase + '\'' + ", warnings=" + this.warnings + ", error=" + this.error + '}';
    }

    @Override
    public State deepClone() {
        return new State(this);
    }
}

