/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.jdbcdrivers;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class JdbcDriverInfo
implements DeepCloneable<JdbcDriverInfo> {
    private String name;
    private String label;
    private Boolean available;
    private String jdbcUrl;
    private Boolean isDefault;
    private String jdbcDriverClass;
    private Boolean allowSpacesInDbName;
    private List<ClientProperty> defaultValues;

    public JdbcDriverInfo() {
    }

    public JdbcDriverInfo(JdbcDriverInfo source) {
        ValueObjectUtils.checkNotNull(source);
        this.name = source.getName();
        this.label = source.getLabel();
        this.available = source.getAvailable();
        this.jdbcUrl = source.getJdbcUrl();
        this.isDefault = source.isDefault();
        this.jdbcDriverClass = source.getJdbcDriverClass();
        this.allowSpacesInDbName = source.getAllowSpacesInDbName();
        this.defaultValues = ValueObjectUtils.copyOf(source.getDefaultValues());
    }

    @Override
    public JdbcDriverInfo deepClone() {
        return new JdbcDriverInfo(this);
    }

    public Boolean getAllowSpacesInDbName() {
        return this.allowSpacesInDbName;
    }

    public JdbcDriverInfo setAllowSpacesInDbName(Boolean allowSpacesInDbName) {
        this.allowSpacesInDbName = allowSpacesInDbName;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public JdbcDriverInfo setName(String name) {
        this.name = name;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public JdbcDriverInfo setLabel(String label) {
        this.label = label;
        return this;
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public JdbcDriverInfo setAvailable(Boolean available) {
        this.available = available;
        return this;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public JdbcDriverInfo setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    @XmlElement(name="isDefault")
    public Boolean isDefault() {
        return this.isDefault;
    }

    public JdbcDriverInfo setDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public String getJdbcDriverClass() {
        return this.jdbcDriverClass;
    }

    public JdbcDriverInfo setJdbcDriverClass(String jdbcDriverClass) {
        this.jdbcDriverClass = jdbcDriverClass;
        return this;
    }

    public List<ClientProperty> getDefaultValues() {
        return this.defaultValues;
    }

    public JdbcDriverInfo setDefaultValues(List<ClientProperty> defaultValues) {
        this.defaultValues = defaultValues;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcDriverInfo)) {
            return false;
        }
        JdbcDriverInfo that = (JdbcDriverInfo)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.available != null ? !this.available.equals(that.available) : that.available != null) {
            return false;
        }
        if (this.jdbcUrl != null ? !this.jdbcUrl.equals(that.jdbcUrl) : that.jdbcUrl != null) {
            return false;
        }
        if (this.isDefault != null ? !this.isDefault.equals(that.isDefault) : that.isDefault != null) {
            return false;
        }
        if (this.jdbcDriverClass != null ? !this.jdbcDriverClass.equals(that.jdbcDriverClass) : that.jdbcDriverClass != null) {
            return false;
        }
        if (this.allowSpacesInDbName != null ? !this.allowSpacesInDbName.equals(that.allowSpacesInDbName) : that.allowSpacesInDbName != null) {
            return false;
        }
        return this.defaultValues != null ? this.defaultValues.equals(that.defaultValues) : that.defaultValues == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.available != null ? this.available.hashCode() : 0);
        result = 31 * result + (this.jdbcUrl != null ? this.jdbcUrl.hashCode() : 0);
        result = 31 * result + (this.isDefault != null ? this.isDefault.hashCode() : 0);
        result = 31 * result + (this.jdbcDriverClass != null ? this.jdbcDriverClass.hashCode() : 0);
        result = 31 * result + (this.allowSpacesInDbName != null ? this.allowSpacesInDbName.hashCode() : 0);
        result = 31 * result + (this.defaultValues != null ? this.defaultValues.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JdbcDriverInfo{name='" + this.name + '\'' + ", label='" + this.label + '\'' + ", available=" + this.available + ", jdbcUrl='" + this.jdbcUrl + '\'' + ", isDefault=" + this.isDefault + ", jdbcDriverClass='" + this.jdbcDriverClass + '\'' + ", allowSpacesInDbName=" + this.allowSpacesInDbName + ", defaultValues=" + this.defaultValues + '}';
    }
}

