/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.job.ClientJobAlertRecipient;
import com.jaspersoft.jasperserver.dto.job.ClientJobAlertState;
import com.jaspersoft.jasperserver.dto.job.adapters.AddressesXmlAdapter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="reportJobAlert")
public class ClientJobAlert
implements DeepCloneable<ClientJobAlert> {
    private Long id;
    private Integer version;
    private ClientJobAlertRecipient recipient;
    private ClientJobAlertState jobState;
    private String messageText;
    private String messageTextWhenJobFails;
    private String subject;
    private Boolean includingStackTrace;
    private Boolean includingReportJobInfo;
    private List<String> toAddresses;

    public ClientJobAlert() {
    }

    public ClientJobAlert(ClientJobAlert other) {
        ValueObjectUtils.checkNotNull(other);
        this.id = other.id;
        this.includingReportJobInfo = other.includingReportJobInfo;
        this.includingStackTrace = other.includingStackTrace;
        this.jobState = other.jobState;
        this.messageText = other.messageText;
        this.messageTextWhenJobFails = other.messageTextWhenJobFails;
        this.recipient = other.recipient;
        this.subject = other.subject;
        this.toAddresses = ValueObjectUtils.copyOf(other.getToAddresses());
        this.version = other.version;
    }

    public List<String> getToAddresses() {
        return this.toAddresses;
    }

    @XmlJavaTypeAdapter(value=AddressesXmlAdapter.class)
    public ClientJobAlert setToAddresses(List<String> toAddresses) {
        this.toAddresses = toAddresses;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public ClientJobAlert setId(Long id) {
        this.id = id;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public ClientJobAlert setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public ClientJobAlertRecipient getRecipient() {
        return this.recipient;
    }

    public ClientJobAlert setRecipient(ClientJobAlertRecipient recipient) {
        this.recipient = recipient;
        return this;
    }

    public ClientJobAlertState getJobState() {
        return this.jobState;
    }

    public ClientJobAlert setJobState(ClientJobAlertState jobState) {
        this.jobState = jobState;
        return this;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public ClientJobAlert setMessageText(String messageText) {
        this.messageText = messageText;
        return this;
    }

    public String getMessageTextWhenJobFails() {
        return this.messageTextWhenJobFails;
    }

    public ClientJobAlert setMessageTextWhenJobFails(String messageTextWhenJobFails) {
        this.messageTextWhenJobFails = messageTextWhenJobFails;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public ClientJobAlert setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Boolean isIncludingStackTrace() {
        return this.includingStackTrace;
    }

    public ClientJobAlert setIncludingStackTrace(Boolean includingStackTrace) {
        this.includingStackTrace = includingStackTrace;
        return this;
    }

    public Boolean isIncludingReportJobInfo() {
        return this.includingReportJobInfo;
    }

    public ClientJobAlert setIncludingReportJobInfo(Boolean includingReportJobInfo) {
        this.includingReportJobInfo = includingReportJobInfo;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientJobAlert)) {
            return false;
        }
        ClientJobAlert jobAlert = (ClientJobAlert)o;
        if (this.id != null ? !this.id.equals(jobAlert.id) : jobAlert.id != null) {
            return false;
        }
        if (this.includingReportJobInfo != null ? !this.includingReportJobInfo.equals(jobAlert.includingReportJobInfo) : jobAlert.includingReportJobInfo != null) {
            return false;
        }
        if (this.includingStackTrace != null ? !this.includingStackTrace.equals(jobAlert.includingStackTrace) : jobAlert.includingStackTrace != null) {
            return false;
        }
        if (this.jobState != null ? !this.jobState.equals((Object)jobAlert.jobState) : jobAlert.jobState != null) {
            return false;
        }
        if (this.messageText != null ? !this.messageText.equals(jobAlert.messageText) : jobAlert.messageText != null) {
            return false;
        }
        if (this.messageTextWhenJobFails != null ? !this.messageTextWhenJobFails.equals(jobAlert.messageTextWhenJobFails) : jobAlert.messageTextWhenJobFails != null) {
            return false;
        }
        if (this.recipient != null ? !this.recipient.equals((Object)jobAlert.recipient) : jobAlert.recipient != null) {
            return false;
        }
        if (this.subject != null ? !this.subject.equals(jobAlert.subject) : jobAlert.subject != null) {
            return false;
        }
        if (this.toAddresses != null ? !this.toAddresses.equals(jobAlert.toAddresses) : jobAlert.toAddresses != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(jobAlert.version) : jobAlert.version != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.recipient != null ? this.recipient.hashCode() : 0);
        result = 31 * result + (this.jobState != null ? this.jobState.hashCode() : 0);
        result = 31 * result + (this.messageText != null ? this.messageText.hashCode() : 0);
        result = 31 * result + (this.messageTextWhenJobFails != null ? this.messageTextWhenJobFails.hashCode() : 0);
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (this.includingStackTrace != null ? this.includingStackTrace.hashCode() : 0);
        result = 31 * result + (this.includingReportJobInfo != null ? this.includingReportJobInfo.hashCode() : 0);
        result = 31 * result + (this.toAddresses != null ? this.toAddresses.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientJobAlert{id=" + this.id + ", version=" + this.version + ", recipient=" + (Object)((Object)this.recipient) + ", jobState=" + (Object)((Object)this.jobState) + ", messageText='" + this.messageText + '\'' + ", messageTextWhenJobFails='" + this.messageTextWhenJobFails + '\'' + ", subject='" + this.subject + '\'' + ", includingStackTrace=" + this.includingStackTrace + ", includingReportJobInfo=" + this.includingReportJobInfo + ", toAddresses=" + this.toAddresses + '}';
    }

    @Override
    public ClientJobAlert deepClone() {
        return new ClientJobAlert(this);
    }
}

