/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.job.adapters.ExcludeDaysXmlAdapter;
import com.jaspersoft.jasperserver.dto.job.adapters.TimeZoneXmlAdapter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="reportJobCalendar")
public class ClientJobCalendar
implements DeepCloneable<ClientJobCalendar> {
    private Type calendarType;
    private ClientJobCalendar baseCalendar;
    private String description;
    private TimeZone timeZone;
    private ArrayList<Calendar> excludeDays = new ArrayList();
    private Boolean dataSorted;
    private String cronExpression;
    private Calendar rangeStartingCalendar;
    private Calendar rangeEndingCalendar;
    private Boolean invertTimeRange;
    private boolean[] excludeDaysFlags;

    public ClientJobCalendar() {
    }

    public ClientJobCalendar(ClientJobCalendar other) {
        ValueObjectUtils.checkNotNull(other);
        this.calendarType = other.getCalendarType();
        this.baseCalendar = ValueObjectUtils.copyOf(other.getBaseCalendar());
        this.description = other.getDescription();
        this.timeZone = ValueObjectUtils.copyOf(other.getTimeZone());
        this.excludeDays = ValueObjectUtils.copyOf(other.getExcludeDays());
        this.dataSorted = other.isDataSorted();
        this.cronExpression = other.getCronExpression();
        this.rangeStartingCalendar = ValueObjectUtils.copyOf(other.getRangeStartingCalendar());
        this.rangeEndingCalendar = ValueObjectUtils.copyOf(other.getRangeEndingCalendar());
        this.invertTimeRange = other.isInvertTimeRange();
        this.excludeDaysFlags = ValueObjectUtils.copyOf(other.getExcludeDaysFlags());
    }

    public Type getCalendarType() {
        return this.calendarType;
    }

    public ClientJobCalendar setCalendarType(Type calendarType) {
        this.calendarType = calendarType;
        return this;
    }

    public ClientJobCalendar getBaseCalendar() {
        return this.baseCalendar;
    }

    public ClientJobCalendar setBaseCalendar(ClientJobCalendar baseCalendar) {
        this.baseCalendar = baseCalendar;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ClientJobCalendar setDescription(String description) {
        this.description = description;
        return this;
    }

    @XmlJavaTypeAdapter(value=TimeZoneXmlAdapter.class)
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public ClientJobCalendar setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @XmlJavaTypeAdapter(value=ExcludeDaysXmlAdapter.class)
    public ArrayList<Calendar> getExcludeDays() {
        return this.excludeDays;
    }

    public ClientJobCalendar setExcludeDays(ArrayList<Calendar> excludeDays) {
        this.excludeDays = excludeDays == null ? new ArrayList() : excludeDays;
        this.setExcludeDaysTimeZone(this.excludeDays);
        return this;
    }

    public ClientJobCalendar setExcludeDaysTimeZone(ArrayList<Calendar> excludeDays) {
        for (Calendar excludeDay : excludeDays) {
            if (this.timeZone == null) continue;
            excludeDay.setTimeZone(this.timeZone);
        }
        return this;
    }

    public Boolean isDataSorted() {
        return this.dataSorted;
    }

    public ClientJobCalendar setDataSorted(Boolean dataSorted) {
        this.dataSorted = dataSorted;
        return this;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public ClientJobCalendar setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    public Calendar getRangeStartingCalendar() {
        return this.rangeStartingCalendar;
    }

    public ClientJobCalendar setRangeStartingCalendar(Calendar rangeStartingCalendar) {
        this.rangeStartingCalendar = rangeStartingCalendar;
        return this;
    }

    public Calendar getRangeEndingCalendar() {
        return this.rangeEndingCalendar;
    }

    public ClientJobCalendar setRangeEndingCalendar(Calendar rangeEndingCalendar) {
        this.rangeEndingCalendar = rangeEndingCalendar;
        return this;
    }

    public Boolean isInvertTimeRange() {
        return this.invertTimeRange;
    }

    public ClientJobCalendar setInvertTimeRange(Boolean invertTimeRange) {
        this.invertTimeRange = invertTimeRange;
        return this;
    }

    @XmlElementWrapper(name="excludeDaysFlags")
    @XmlElement(name="excludeDayFlag")
    public boolean[] getExcludeDaysFlags() {
        return this.excludeDaysFlags;
    }

    public ClientJobCalendar setExcludeDaysFlags(boolean[] excludeDaysFlags) {
        this.excludeDaysFlags = excludeDaysFlags;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientJobCalendar)) {
            return false;
        }
        ClientJobCalendar that = (ClientJobCalendar)o;
        if (this.calendarType != that.calendarType) {
            return false;
        }
        if (this.baseCalendar != null ? !this.baseCalendar.equals(that.baseCalendar) : that.baseCalendar != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.timeZone != null ? !this.timeZone.equals(that.timeZone) : that.timeZone != null) {
            return false;
        }
        if (!this.excludeDays.equals(that.excludeDays)) {
            return false;
        }
        if (this.dataSorted != null ? !this.dataSorted.equals(that.dataSorted) : that.dataSorted != null) {
            return false;
        }
        if (this.cronExpression != null ? !this.cronExpression.equals(that.cronExpression) : that.cronExpression != null) {
            return false;
        }
        if (this.rangeStartingCalendar != null ? !this.rangeStartingCalendar.equals(that.rangeStartingCalendar) : that.rangeStartingCalendar != null) {
            return false;
        }
        if (this.rangeEndingCalendar != null ? !this.rangeEndingCalendar.equals(that.rangeEndingCalendar) : that.rangeEndingCalendar != null) {
            return false;
        }
        if (this.invertTimeRange != null ? !this.invertTimeRange.equals(that.invertTimeRange) : that.invertTimeRange != null) {
            return false;
        }
        return Arrays.equals(this.excludeDaysFlags, that.excludeDaysFlags);
    }

    public int hashCode() {
        int result = this.calendarType != null ? this.calendarType.hashCode() : 0;
        result = 31 * result + (this.baseCalendar != null ? this.baseCalendar.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + this.excludeDays.hashCode();
        result = 31 * result + (this.dataSorted != null ? this.dataSorted.hashCode() : 0);
        result = 31 * result + (this.cronExpression != null ? this.cronExpression.hashCode() : 0);
        result = 31 * result + (this.rangeStartingCalendar != null ? this.rangeStartingCalendar.hashCode() : 0);
        result = 31 * result + (this.rangeEndingCalendar != null ? this.rangeEndingCalendar.hashCode() : 0);
        result = 31 * result + (this.invertTimeRange != null ? this.invertTimeRange.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.excludeDaysFlags);
        return result;
    }

    public String toString() {
        return "ClientJobCalendar{baseCalendar=" + this.baseCalendar + ", calendarType=" + (Object)((Object)this.calendarType) + ", description='" + this.description + '\'' + ", timeZone=" + this.timeZone + ", excludeDays=" + this.excludeDays + ", dataSorted=" + this.dataSorted + ", cronExpression='" + this.cronExpression + '\'' + ", rangeStartingCalendar=" + this.rangeStartingCalendar + ", rangeEndingCalendar=" + this.rangeEndingCalendar + ", invertTimeRange=" + this.invertTimeRange + ", excludeDaysFlags=" + Arrays.toString(this.excludeDaysFlags) + '}';
    }

    @Override
    public ClientJobCalendar deepClone() {
        return new ClientJobCalendar(this);
    }

    public static enum Type {
        annual,
        base,
        cron,
        daily,
        holiday,
        monthly,
        weekly;

    }
}

