/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job;

import com.jaspersoft.jasperserver.dto.job.ClientCalendarDaysType;
import com.jaspersoft.jasperserver.dto.job.ClientJobTrigger;
import com.jaspersoft.jasperserver.dto.job.adapters.DaysByteXmlAdapter;
import com.jaspersoft.jasperserver.dto.job.adapters.MonthsByteXmlAdapter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.SortedSet;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="calendarTrigger")
public class ClientJobCalendarTrigger
extends ClientJobTrigger {
    private String minutes;
    private String hours;
    private ClientCalendarDaysType daysType;
    private SortedSet<Byte> weekDays;
    private String monthDays;
    private SortedSet<Byte> months;

    public ClientJobCalendarTrigger() {
    }

    public ClientJobCalendarTrigger(ClientJobCalendarTrigger other) {
        super(other);
        this.minutes = other.getMinutes();
        this.hours = other.getHours();
        this.daysType = other.getDaysType();
        this.weekDays = ValueObjectUtils.copyOf(other.getWeekDays());
        this.monthDays = other.getMonthDays();
        this.months = ValueObjectUtils.copyOf(other.getMonths());
    }

    public String getMinutes() {
        return this.minutes;
    }

    public ClientJobCalendarTrigger setMinutes(String minutes) {
        this.minutes = minutes;
        return this;
    }

    public String getHours() {
        return this.hours;
    }

    public ClientJobCalendarTrigger setHours(String hours) {
        this.hours = hours;
        return this;
    }

    public String getMonthDays() {
        return this.monthDays;
    }

    public ClientJobCalendarTrigger setMonthDays(String monthDays) {
        this.monthDays = monthDays;
        return this;
    }

    public ClientCalendarDaysType getDaysType() {
        return this.daysType;
    }

    public ClientJobCalendarTrigger setDaysType(ClientCalendarDaysType daysType) {
        this.daysType = daysType;
        return this;
    }

    @XmlJavaTypeAdapter(value=DaysByteXmlAdapter.class)
    public SortedSet<Byte> getWeekDays() {
        return this.weekDays;
    }

    public ClientJobCalendarTrigger setWeekDays(SortedSet<Byte> weekDays) {
        this.weekDays = weekDays;
        return this;
    }

    @XmlJavaTypeAdapter(value=MonthsByteXmlAdapter.class)
    public SortedSet<Byte> getMonths() {
        return this.months;
    }

    public ClientJobCalendarTrigger setMonths(SortedSet<Byte> months) {
        this.months = months;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientJobCalendarTrigger that = (ClientJobCalendarTrigger)o;
        if (this.minutes != null ? !this.minutes.equals(that.minutes) : that.minutes != null) {
            return false;
        }
        if (this.hours != null ? !this.hours.equals(that.hours) : that.hours != null) {
            return false;
        }
        if (this.daysType != that.daysType) {
            return false;
        }
        if (this.weekDays != null ? !this.weekDays.equals(that.weekDays) : that.weekDays != null) {
            return false;
        }
        if (this.monthDays != null ? !this.monthDays.equals(that.monthDays) : that.monthDays != null) {
            return false;
        }
        return this.months != null ? this.months.equals(that.months) : that.months == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.minutes != null ? this.minutes.hashCode() : 0);
        result = 31 * result + (this.hours != null ? this.hours.hashCode() : 0);
        result = 31 * result + (this.daysType != null ? this.daysType.hashCode() : 0);
        result = 31 * result + (this.weekDays != null ? this.weekDays.hashCode() : 0);
        result = 31 * result + (this.monthDays != null ? this.monthDays.hashCode() : 0);
        result = 31 * result + (this.months != null ? this.months.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ClientJobCalendarTrigger{minutes='" + this.minutes + '\'' + ", hours='" + this.hours + '\'' + ", daysType='" + (Object)((Object)this.daysType) + '\'' + ", weekDays=" + this.weekDays + ", monthDays='" + this.monthDays + '\'' + ", months=" + this.months + "} " + super.toString();
    }
}

