/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.job.adapters.ReportJobSourceParametersXmlAdapter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="source")
public class ClientJobSource
implements DeepCloneable<ClientJobSource> {
    private String reportUnitURI;
    private Map<String, String[]> parameters;
    private Integer referenceHeight;
    private Integer referenceWidth;

    public ClientJobSource() {
    }

    public ClientJobSource(ClientJobSource other) {
        ValueObjectUtils.checkNotNull(other);
        this.reportUnitURI = other.getReportUnitURI();
        this.referenceHeight = other.getReferenceHeight();
        this.referenceWidth = other.getReferenceWidth();
        this.parameters = ValueObjectUtils.copyOf(other.getParameters());
    }

    public String getReportUnitURI() {
        return this.reportUnitURI;
    }

    public ClientJobSource setReportUnitURI(String reportUnitURI) {
        this.reportUnitURI = reportUnitURI;
        return this;
    }

    public Integer getReferenceHeight() {
        return this.referenceHeight;
    }

    public ClientJobSource setReferenceHeight(Integer referenceHeight) {
        this.referenceHeight = referenceHeight;
        return this;
    }

    public Integer getReferenceWidth() {
        return this.referenceWidth;
    }

    public ClientJobSource setReferenceWidth(Integer referenceWidth) {
        this.referenceWidth = referenceWidth;
        return this;
    }

    @XmlJavaTypeAdapter(value=ReportJobSourceParametersXmlAdapter.class)
    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public ClientJobSource setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientJobSource)) {
            return false;
        }
        ClientJobSource source = (ClientJobSource)o;
        if (!ValueObjectUtils.isMapsWithArraysAsValuesEquals(this.parameters, source.parameters)) {
            return false;
        }
        if (this.reportUnitURI != null ? !this.reportUnitURI.equals(source.reportUnitURI) : source.reportUnitURI != null) {
            return false;
        }
        if (this.referenceHeight != null ? !this.referenceHeight.equals(source.referenceHeight) : source.referenceHeight != null) {
            return false;
        }
        return !(this.referenceWidth != null ? !this.referenceWidth.equals(source.referenceWidth) : source.referenceWidth != null);
    }

    public int hashCode() {
        int result = this.reportUnitURI != null ? this.reportUnitURI.hashCode() : 0;
        result = 31 * result + ValueObjectUtils.hashCodeOfMapWithArraysAsValues(this.parameters);
        result = 31 * result + (this.referenceHeight != null ? this.referenceHeight.hashCode() : 0);
        result = 31 * result + (this.referenceWidth != null ? this.referenceWidth.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientJobSource{reportUnitURI='" + this.reportUnitURI + '\'' + ", parameters=" + this.parameters + '}';
    }

    @Override
    public ClientJobSource deepClone() {
        return new ClientJobSource(this);
    }
}

