/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.job.ClientJobStateType;
import com.jaspersoft.jasperserver.dto.job.adapters.DateToStringXmlAdapter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="state")
public class ClientJobState
implements DeepCloneable<ClientJobState> {
    private Date previousFireTime;
    private Date nextFireTime;
    private ClientJobStateType state;

    public ClientJobState() {
    }

    public ClientJobState(ClientJobState other) {
        ValueObjectUtils.checkNotNull(other);
        this.nextFireTime = ValueObjectUtils.copyOf(other.getNextFireTime());
        this.previousFireTime = ValueObjectUtils.copyOf(other.getPreviousFireTime());
        this.state = other.getState();
    }

    @XmlJavaTypeAdapter(value=DateToStringXmlAdapter.class)
    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public ClientJobState setPreviousFireTime(Date previousFireTime) {
        this.previousFireTime = previousFireTime;
        return this;
    }

    @XmlJavaTypeAdapter(value=DateToStringXmlAdapter.class)
    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public ClientJobState setNextFireTime(Date nextFireTime) {
        this.nextFireTime = nextFireTime;
        return this;
    }

    @XmlElement(name="value")
    public ClientJobStateType getState() {
        return this.state;
    }

    public ClientJobState setState(ClientJobStateType state) {
        this.state = state;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientJobState)) {
            return false;
        }
        ClientJobState that = (ClientJobState)o;
        if (this.getPreviousFireTime() != null ? !this.getPreviousFireTime().equals(that.getPreviousFireTime()) : that.getPreviousFireTime() != null) {
            return false;
        }
        if (this.getNextFireTime() != null ? !this.getNextFireTime().equals(that.getNextFireTime()) : that.getNextFireTime() != null) {
            return false;
        }
        return this.getState() == that.getState();
    }

    public int hashCode() {
        int result = this.getPreviousFireTime() != null ? this.getPreviousFireTime().hashCode() : 0;
        result = 31 * result + (this.getNextFireTime() != null ? this.getNextFireTime().hashCode() : 0);
        result = 31 * result + (this.getState() != null ? this.getState().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientJobState{nextFireTime=" + this.nextFireTime + ", previousFireTime=" + this.previousFireTime + ", state=" + (Object)((Object)this.state) + '}';
    }

    @Override
    public ClientJobState deepClone() {
        return new ClientJobState(this);
    }
}

