/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.job.adapters.NoTimezoneDateToStringXmlAdapter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.lang.reflect.Constructor;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public abstract class ClientJobTrigger
implements DeepCloneable<ClientJobTrigger> {
    public static final byte START_TYPE_NOW = 1;
    public static final byte START_TYPE_SCHEDULE = 2;
    private Long id;
    private Integer version;
    private String timezone;
    private String calendarName;
    private int startType;
    private Date startDate;
    private Date endDate;
    private Integer misfireInstruction;

    public ClientJobTrigger() {
    }

    public ClientJobTrigger(ClientJobTrigger other) {
        ValueObjectUtils.checkNotNull(other);
        this.id = other.getId();
        this.version = other.getVersion();
        this.timezone = other.getTimezone();
        this.calendarName = other.getCalendarName();
        this.startType = other.getStartType();
        this.startDate = ValueObjectUtils.copyOf(other.getStartDate());
        this.endDate = ValueObjectUtils.copyOf(other.getEndDate());
        this.misfireInstruction = other.misfireInstruction;
    }

    public Long getId() {
        return this.id;
    }

    public ClientJobTrigger setId(Long id) {
        this.id = id;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public ClientJobTrigger setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public ClientJobTrigger setTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    public String getCalendarName() {
        return this.calendarName;
    }

    public ClientJobTrigger setCalendarName(String calendarName) {
        this.calendarName = calendarName;
        return this;
    }

    public int getStartType() {
        return this.startType;
    }

    public ClientJobTrigger setStartType(int startType) {
        this.startType = startType;
        return this;
    }

    @XmlJavaTypeAdapter(value=NoTimezoneDateToStringXmlAdapter.class)
    public Date getStartDate() {
        return this.startDate;
    }

    public ClientJobTrigger setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @XmlJavaTypeAdapter(value=NoTimezoneDateToStringXmlAdapter.class)
    public Date getEndDate() {
        return this.endDate;
    }

    public ClientJobTrigger setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public Integer getMisfireInstruction() {
        return this.misfireInstruction;
    }

    public ClientJobTrigger setMisfireInstruction(Integer misfireInstruction) {
        this.misfireInstruction = misfireInstruction;
        return this;
    }

    @Override
    public ClientJobTrigger deepClone() {
        Class<?> thisClass = this.getClass();
        ClientJobTrigger instance = null;
        try {
            Constructor<?> constructor = thisClass.getConstructor(thisClass);
            instance = (ClientJobTrigger)constructor.newInstance(this);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        return instance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientJobTrigger)) {
            return false;
        }
        ClientJobTrigger trigger = (ClientJobTrigger)o;
        if (this.startType != trigger.startType) {
            return false;
        }
        if (this.calendarName != null ? !this.calendarName.equals(trigger.calendarName) : trigger.calendarName != null) {
            return false;
        }
        if (this.endDate != null ? !this.endDate.equals(trigger.endDate) : trigger.endDate != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(trigger.id) : trigger.id != null) {
            return false;
        }
        if (this.misfireInstruction != null ? !this.misfireInstruction.equals(trigger.misfireInstruction) : trigger.misfireInstruction != null) {
            return false;
        }
        if (this.startDate != null ? !this.startDate.equals(trigger.startDate) : trigger.startDate != null) {
            return false;
        }
        if (this.timezone != null ? !this.timezone.equals(trigger.timezone) : trigger.timezone != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(trigger.version) : trigger.version != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
        result = 31 * result + (this.calendarName != null ? this.calendarName.hashCode() : 0);
        result = 31 * result + this.startType;
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.misfireInstruction != null ? this.misfireInstruction.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientJobTrigger{id=" + this.id + ", version=" + this.version + ", timezone='" + this.timezone + '\'' + ", calendarName='" + this.calendarName + '\'' + ", startType=" + this.startType + ", startDate='" + this.startDate + '\'' + ", endDate='" + this.endDate + '\'' + ", misfireInstruction=" + this.misfireInstruction + '}';
    }
}

