/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.common.ExportType;
import com.jaspersoft.jasperserver.dto.common.OutputFormat;
import com.jaspersoft.jasperserver.dto.job.ClientJobAlert;
import com.jaspersoft.jasperserver.dto.job.ClientJobCalendarTrigger;
import com.jaspersoft.jasperserver.dto.job.ClientJobMailNotification;
import com.jaspersoft.jasperserver.dto.job.ClientJobRepositoryDestination;
import com.jaspersoft.jasperserver.dto.job.ClientJobSimpleTrigger;
import com.jaspersoft.jasperserver.dto.job.ClientJobSource;
import com.jaspersoft.jasperserver.dto.job.ClientJobTrigger;
import com.jaspersoft.jasperserver.dto.job.adapters.OutputFormatXmlAdapter;
import com.jaspersoft.jasperserver.dto.job.adapters.TimestampToStringXmlAdapter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.sql.Timestamp;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="job")
public class ClientReportJob
implements DeepCloneable<ClientReportJob> {
    private Long id;
    private Integer version;
    private String username;
    private String label;
    private String description;
    private Timestamp creationDate;
    private ClientJobTrigger trigger;
    private ClientJobSource source;
    private String baseOutputFilename;
    private ExportType exportType;
    private Set<OutputFormat> outputFormats;
    private String outputLocale;
    private String outputTimeZone;
    private ClientJobRepositoryDestination repositoryDestination;
    private ClientJobMailNotification mailNotification;
    private ClientJobAlert alert;

    public ClientReportJob() {
    }

    public ClientReportJob(ClientReportJob other) {
        ValueObjectUtils.checkNotNull(other);
        this.id = other.getId();
        this.version = other.getVersion();
        this.username = other.getUsername();
        this.label = other.getLabel();
        this.description = other.getDescription();
        this.creationDate = ValueObjectUtils.copyOf(other.getCreationDate());
        this.trigger = ValueObjectUtils.copyOf(other.getTrigger());
        this.source = ValueObjectUtils.copyOf(other.getSource());
        this.exportType = other.getExportType();
        this.baseOutputFilename = other.getBaseOutputFilename();
        this.outputFormats = ValueObjectUtils.copyOf(other.getOutputFormats());
        this.outputLocale = other.getOutputLocale();
        this.outputTimeZone = other.getOutputTimeZone();
        this.repositoryDestination = ValueObjectUtils.copyOf(other.getRepositoryDestination());
        this.mailNotification = ValueObjectUtils.copyOf(other.getMailNotification());
        this.alert = ValueObjectUtils.copyOf(other.getAlert());
    }

    public Long getId() {
        return this.id;
    }

    public ClientReportJob setId(Long id) {
        this.id = id;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public ClientReportJob setVersion(Integer version) {
        this.version = version;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public ClientReportJob setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public ClientReportJob setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public ClientReportJob setDescription(String description) {
        this.description = description;
        return this;
    }

    @XmlJavaTypeAdapter(value=TimestampToStringXmlAdapter.class)
    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public ClientReportJob setCreationDate(Timestamp creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public String getBaseOutputFilename() {
        return this.baseOutputFilename;
    }

    public ClientReportJob setBaseOutputFilename(String baseOutputFilename) {
        this.baseOutputFilename = baseOutputFilename;
        return this;
    }

    public String getOutputLocale() {
        return this.outputLocale;
    }

    public ClientReportJob setOutputLocale(String outputLocale) {
        this.outputLocale = outputLocale;
        return this;
    }

    @XmlElement(name="repositoryDestination")
    public ClientJobRepositoryDestination getRepositoryDestination() {
        return this.repositoryDestination;
    }

    public ClientReportJob setRepositoryDestination(ClientJobRepositoryDestination repositoryDestination) {
        this.repositoryDestination = repositoryDestination;
        return this;
    }

    @XmlElement(name="mailNotification")
    public ClientJobMailNotification getMailNotification() {
        return this.mailNotification;
    }

    public ClientReportJob setMailNotification(ClientJobMailNotification mailNotification) {
        this.mailNotification = mailNotification;
        return this;
    }

    @XmlElement(name="source")
    public ClientJobSource getSource() {
        return this.source;
    }

    public ClientReportJob setSource(ClientJobSource source) {
        this.source = source;
        return this;
    }

    @XmlElement(name="alert")
    public ClientJobAlert getAlert() {
        return this.alert;
    }

    public ClientReportJob setAlert(ClientJobAlert alert) {
        this.alert = alert;
        return this;
    }

    @XmlElements(value={@XmlElement(name="simpleTrigger", type=ClientJobSimpleTrigger.class), @XmlElement(name="calendarTrigger", type=ClientJobCalendarTrigger.class)})
    public ClientJobTrigger getTrigger() {
        return this.trigger;
    }

    public ClientReportJob setTrigger(ClientJobTrigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public ExportType getExportType() {
        return this.exportType;
    }

    public ClientReportJob setExportType(ExportType exportType) {
        this.exportType = exportType;
        return this;
    }

    @XmlElement(name="outputFormats")
    @XmlJavaTypeAdapter(value=OutputFormatXmlAdapter.class)
    public Set<OutputFormat> getOutputFormats() {
        return this.outputFormats;
    }

    public ClientReportJob setOutputFormats(Set<OutputFormat> outputFormats) {
        this.outputFormats = outputFormats;
        return this;
    }

    public String getOutputTimeZone() {
        return this.outputTimeZone;
    }

    public ClientReportJob setOutputTimeZone(String outputTimeZone) {
        this.outputTimeZone = outputTimeZone;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientReportJob)) {
            return false;
        }
        ClientReportJob that = (ClientReportJob)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.creationDate != null ? !this.creationDate.equals(that.creationDate) : that.creationDate != null) {
            return false;
        }
        if (this.trigger != null ? !this.trigger.equals(that.trigger) : that.trigger != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.exportType != null ? !this.exportType.equals((Object)that.exportType) : that.exportType != null) {
            return false;
        }
        if (this.baseOutputFilename != null ? !this.baseOutputFilename.equals(that.baseOutputFilename) : that.baseOutputFilename != null) {
            return false;
        }
        if (this.outputFormats != null ? !this.outputFormats.equals(that.outputFormats) : that.outputFormats != null) {
            return false;
        }
        if (this.outputLocale != null ? !this.outputLocale.equals(that.outputLocale) : that.outputLocale != null) {
            return false;
        }
        if (this.outputTimeZone != null ? !this.outputTimeZone.equals(that.outputTimeZone) : that.outputTimeZone != null) {
            return false;
        }
        if (this.repositoryDestination != null ? !this.repositoryDestination.equals(that.repositoryDestination) : that.repositoryDestination != null) {
            return false;
        }
        if (this.mailNotification != null ? !this.mailNotification.equals(that.mailNotification) : that.mailNotification != null) {
            return false;
        }
        return !(this.alert != null ? !this.alert.equals(that.alert) : that.alert != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
        result = 31 * result + (this.trigger != null ? this.trigger.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.exportType != null ? this.exportType.hashCode() : 0);
        result = 31 * result + (this.baseOutputFilename != null ? this.baseOutputFilename.hashCode() : 0);
        result = 31 * result + (this.outputFormats != null ? this.outputFormats.hashCode() : 0);
        result = 31 * result + (this.outputLocale != null ? this.outputLocale.hashCode() : 0);
        result = 31 * result + (this.outputTimeZone != null ? this.outputTimeZone.hashCode() : 0);
        result = 31 * result + (this.repositoryDestination != null ? this.repositoryDestination.hashCode() : 0);
        result = 31 * result + (this.mailNotification != null ? this.mailNotification.hashCode() : 0);
        result = 31 * result + (this.alert != null ? this.alert.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClientReportJob{id=" + this.id + ", version=" + this.version + ", username='" + this.username + '\'' + ", label='" + this.label + '\'' + ", description='" + this.description + '\'' + ", creationDate=" + this.creationDate + ", trigger=" + this.trigger + ", source=" + this.source + ", baseOutputFilename='" + this.baseOutputFilename + '\'' + ", exportType=" + (Object)((Object)this.exportType) + ", outputFormats=" + this.outputFormats + ", outputLocale='" + this.outputLocale + '\'' + ", outputTimeZone='" + this.outputTimeZone + '\'' + ", repositoryDestination=" + this.repositoryDestination + ", mailNotification=" + this.mailNotification + ", alert=" + this.alert + '}';
    }

    @Override
    public ClientReportJob deepClone() {
        return new ClientReportJob(this);
    }
}

