/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job.wrappers;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ClientAddressesListWrapper
implements DeepCloneable<ClientAddressesListWrapper> {
    private List<String> addresses;

    public ClientAddressesListWrapper() {
    }

    public ClientAddressesListWrapper(List<String> otherAddresses) {
        if (otherAddresses == null) {
            return;
        }
        this.addresses = new ArrayList<String>(otherAddresses);
    }

    public ClientAddressesListWrapper(ClientAddressesListWrapper other) {
        ValueObjectUtils.checkNotNull(other);
        this.addresses = ValueObjectUtils.copyOf(other.getAddresses());
    }

    @XmlElement(name="address")
    public List<String> getAddresses() {
        return this.addresses;
    }

    public ClientAddressesListWrapper setAddresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientAddressesListWrapper)) {
            return false;
        }
        ClientAddressesListWrapper that = (ClientAddressesListWrapper)o;
        return !(this.getAddresses() == null ? that.getAddresses() != null : !this.getAddresses().equals(that.getAddresses()));
    }

    public int hashCode() {
        return this.getAddresses() != null ? this.getAddresses().hashCode() : 0;
    }

    public String toString() {
        return "ClientAddressesListWrapper{addresses=" + this.addresses + '}';
    }

    @Override
    public ClientAddressesListWrapper deepClone() {
        return new ClientAddressesListWrapper(this);
    }
}

