/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job.wrappers;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ClientDaysSortedSetWrapper
implements DeepCloneable<ClientDaysSortedSetWrapper> {
    private SortedSet<String> days;

    public ClientDaysSortedSetWrapper() {
    }

    public ClientDaysSortedSetWrapper(SortedSet<String> days) {
        if (days == null) {
            return;
        }
        this.days = new TreeSet<String>(days);
    }

    public ClientDaysSortedSetWrapper(ClientDaysSortedSetWrapper other) {
        ValueObjectUtils.checkNotNull(other);
        this.days = ValueObjectUtils.copyOf(other.getDays());
    }

    @XmlElement(name="day")
    public SortedSet<String> getDays() {
        return this.days;
    }

    public ClientDaysSortedSetWrapper setDays(SortedSet<String> days) {
        this.days = days;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientDaysSortedSetWrapper)) {
            return false;
        }
        ClientDaysSortedSetWrapper that = (ClientDaysSortedSetWrapper)o;
        return !(this.getDays() == null ? that.getDays() != null : !this.getDays().equals(that.getDays()));
    }

    public String toString() {
        return "ClientDaysSortedSetWrapper{days=" + this.days + '}';
    }

    public int hashCode() {
        return this.getDays() != null ? this.getDays().hashCode() : 0;
    }

    @Override
    public ClientDaysSortedSetWrapper deepClone() {
        return new ClientDaysSortedSetWrapper(this);
    }
}

