/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.job.wrappers;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="months")
public class ClientMonthsSortedSetWrapper
implements DeepCloneable<ClientMonthsSortedSetWrapper> {
    private SortedSet<String> mongths;

    public ClientMonthsSortedSetWrapper() {
    }

    public ClientMonthsSortedSetWrapper(SortedSet<String> months) {
        if (months == null) {
            return;
        }
        this.mongths = new TreeSet<String>(months);
    }

    public ClientMonthsSortedSetWrapper(ClientMonthsSortedSetWrapper other) {
        ValueObjectUtils.checkNotNull(other);
        this.mongths = ValueObjectUtils.copyOf(other.getMongths());
    }

    @XmlElement(name="month")
    public SortedSet<String> getMongths() {
        return this.mongths;
    }

    public ClientMonthsSortedSetWrapper setMongths(SortedSet<String> months) {
        this.mongths = months;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientMonthsSortedSetWrapper)) {
            return false;
        }
        ClientMonthsSortedSetWrapper that = (ClientMonthsSortedSetWrapper)o;
        return !(this.getMongths() == null ? that.getMongths() != null : !this.getMongths().equals(that.getMongths()));
    }

    public int hashCode() {
        return this.getMongths() != null ? this.getMongths().hashCode() : 0;
    }

    public String toString() {
        return "ClientMonthsSortedSetWrapper{mongths=" + this.mongths + '}';
    }

    @Override
    public ClientMonthsSortedSetWrapper deepClone() {
        return new ClientMonthsSortedSetWrapper(this);
    }
}

