/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.logcapture;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.logcapture.LogFilterParameters;
import com.jaspersoft.jasperserver.dto.logcapture.ResourceAndSnapshotFilter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"id", "name", "verbosity", "logFilterParameters", "status", "keyalias"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class CollectorSettings
implements DeepCloneable<CollectorSettings> {
    private LogFilterParameters logFilterParameters;
    private String id;
    private String name;
    private String verbosity;
    private String status;
    private String keyalias;

    public static void marshall(CollectorSettings collectorSettings, String filePath) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CollectorSettings.class});
        Marshaller xmlMarshaller = jaxbContext.createMarshaller();
        xmlMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        xmlMarshaller.marshal((Object)collectorSettings, new File(filePath));
    }

    public static CollectorSettings unMarshall(String filePath) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CollectorSettings.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return (CollectorSettings)unmarshaller.unmarshal(new File(filePath));
    }

    public CollectorSettings() {
        this.logFilterParameters = new LogFilterParameters();
    }

    public CollectorSettings(CollectorSettings other) {
        ValueObjectUtils.checkNotNull(other);
        this.id = other.getId();
        this.name = other.getName();
        this.verbosity = other.getVerbosity();
        this.status = other.getStatus();
        this.logFilterParameters = ValueObjectUtils.copyOf(other.getLogFilterParameters());
        this.keyalias = other.getKeyalias();
    }

    @Override
    public CollectorSettings deepClone() {
        return new CollectorSettings(this);
    }

    public boolean exportEnabled() {
        if (this.logFilterParameters == null) {
            return false;
        }
        ResourceAndSnapshotFilter resourceAndSnapshotFilter = this.logFilterParameters.getResourceAndSnapshotFilter();
        return resourceAndSnapshotFilter != null && resourceAndSnapshotFilter.exportDatasnapshotEnabled();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CollectorSettings)) {
            return false;
        }
        CollectorSettings that = (CollectorSettings)o;
        if (this.logFilterParameters != null ? !this.logFilterParameters.equals(that.logFilterParameters) : that.logFilterParameters != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.verbosity != null ? !this.verbosity.equals(that.verbosity) : that.verbosity != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return this.keyalias != null ? this.keyalias.equals(that.keyalias) : that.keyalias == null;
    }

    public int hashCode() {
        int result = this.logFilterParameters != null ? this.logFilterParameters.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.verbosity != null ? this.verbosity.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.keyalias != null ? this.keyalias.hashCode() : 0);
        return result;
    }

    @XmlElement(name="filterBy")
    public LogFilterParameters getLogFilterParameters() {
        return this.logFilterParameters;
    }

    public CollectorSettings setLogFilterParameters(LogFilterParameters logFilterParameters) {
        this.logFilterParameters = logFilterParameters;
        return this;
    }

    public String toString() {
        return "CollectorSettings{logFilterParameters=" + this.logFilterParameters + ", id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", verbosity='" + this.verbosity + '\'' + ", status='" + this.status + '\'' + ", keyalias='" + this.keyalias + '\'' + '}';
    }

    public String getId() {
        return this.id;
    }

    public CollectorSettings setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CollectorSettings setName(String name) {
        this.name = name;
        return this;
    }

    public String getVerbosity() {
        return this.verbosity;
    }

    public CollectorSettings setVerbosity(String verbosity) {
        this.verbosity = verbosity;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public CollectorSettings setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getKeyalias() {
        return this.keyalias;
    }

    public CollectorSettings setKeyalias(String keyalias) {
        this.keyalias = keyalias;
        return this;
    }
}

