/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.logcapture;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"resourceUri", "includeDataSnapshots"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ResourceAndSnapshotFilter
implements DeepCloneable<ResourceAndSnapshotFilter> {
    private String resourceUri;
    private Boolean includeDataSnapshots;

    public ResourceAndSnapshotFilter() {
    }

    public ResourceAndSnapshotFilter(ResourceAndSnapshotFilter other) {
        ValueObjectUtils.checkNotNull(other);
        this.resourceUri = other.getResourceUri();
        this.includeDataSnapshots = other.getIncludeDataSnapshots();
    }

    @Override
    public ResourceAndSnapshotFilter deepClone() {
        return new ResourceAndSnapshotFilter(this);
    }

    public boolean exportEnabled() {
        return this.includeDataSnapshots != null && this.includeDataSnapshots != false && this.resourceUri != null && this.resourceUri.length() > 0;
    }

    public boolean exportDatasnapshotEnabled() {
        return Boolean.TRUE.equals(this.includeDataSnapshots) && this.resourceUriSet();
    }

    public boolean resourceUriSet() {
        return this.resourceUri != null && !this.resourceUri.trim().isEmpty();
    }

    public boolean resourceUriMatch(String otherUri) {
        return this.resourceUriSet() && this.resourceUri.equals(otherUri);
    }

    @XmlElement(name="uri")
    public String getResourceUri() {
        return this.resourceUri;
    }

    public ResourceAndSnapshotFilter setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
        return this;
    }

    @XmlElement(name="includeDataSnapshot")
    public Boolean getIncludeDataSnapshots() {
        return this.includeDataSnapshots;
    }

    public ResourceAndSnapshotFilter setIncludeDataSnapshots(Boolean includeDataSnapshots) {
        this.includeDataSnapshots = includeDataSnapshots;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceAndSnapshotFilter)) {
            return false;
        }
        ResourceAndSnapshotFilter that = (ResourceAndSnapshotFilter)o;
        if (this.getResourceUri() != null ? !this.getResourceUri().equals(that.getResourceUri()) : that.getResourceUri() != null) {
            return false;
        }
        return !(this.getIncludeDataSnapshots() == null ? that.getIncludeDataSnapshots() != null : !this.getIncludeDataSnapshots().equals(that.getIncludeDataSnapshots()));
    }

    public int hashCode() {
        int result = this.getResourceUri() != null ? this.getResourceUri().hashCode() : 0;
        result = 31 * result + (this.getIncludeDataSnapshots() != null ? this.getIncludeDataSnapshots().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResourceAndSnapshotFilter{resourceUri='" + this.resourceUri + '\'' + ", includeDataSnapshots=" + this.includeDataSnapshots + '}';
    }
}

