/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.permissions;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.permissions.RepositoryPermission;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="permissions")
public class RepositoryPermissionListWrapper
implements DeepCloneable<RepositoryPermissionListWrapper> {
    private List<RepositoryPermission> permissions;

    public RepositoryPermissionListWrapper() {
    }

    public RepositoryPermissionListWrapper(List<RepositoryPermission> permissions) {
        this.permissions = permissions;
    }

    public RepositoryPermissionListWrapper(RepositoryPermissionListWrapper other) {
        ValueObjectUtils.checkNotNull(other);
        this.permissions = ValueObjectUtils.copyOf(other.getPermissions());
    }

    @Override
    public RepositoryPermissionListWrapper deepClone() {
        return new RepositoryPermissionListWrapper(this);
    }

    @XmlElement(name="permission")
    public List<RepositoryPermission> getPermissions() {
        return this.permissions;
    }

    public RepositoryPermissionListWrapper setPermissions(List<RepositoryPermission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryPermissionListWrapper that = (RepositoryPermissionListWrapper)o;
        return !(this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null);
    }

    public int hashCode() {
        return this.permissions != null ? this.permissions.hashCode() : 0;
    }

    public String toString() {
        return "RepositoryPermissionListWrapper{permissions=" + this.permissions + '}';
    }
}

