/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.query;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.query.QueryResultRow;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="queryResult")
@XmlType(propOrder={"names", "rows"})
public class QueryResult
implements DeepCloneable<QueryResult> {
    private List<String> names = new ArrayList<String>();
    private List<QueryResultRow> rows = new ArrayList<QueryResultRow>();

    public QueryResult() {
    }

    public QueryResult(List<String> names, QueryResultRow ... rows) {
        this.names = names;
        this.rows.addAll(Arrays.asList(rows));
    }

    public QueryResult(QueryResult other) {
        ValueObjectUtils.checkNotNull(other);
        this.names = ValueObjectUtils.copyOf(other.getNames());
        this.rows = ValueObjectUtils.copyOf(other.getRows());
    }

    @Override
    public QueryResult deepClone() {
        return new QueryResult(this);
    }

    @XmlElement(name="name")
    @XmlElementWrapper(name="names")
    public List<String> getNames() {
        return this.names;
    }

    public QueryResult setNames(List<String> names) {
        this.names = names == null ? new ArrayList() : names;
        return this;
    }

    @XmlElement(name="row")
    @XmlElementWrapper(name="values")
    public List<QueryResultRow> getRows() {
        return this.rows;
    }

    public QueryResult setRows(List<QueryResultRow> rows) {
        this.rows = rows == null ? new ArrayList() : rows;
        return this;
    }

    public String toString() {
        return "QueryResult{names=" + this.names + ", rows=" + this.rows + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        if (!this.names.equals(that.names)) {
            return false;
        }
        return this.rows.equals(that.rows);
    }

    public int hashCode() {
        int result = this.names.hashCode();
        result = 31 * result + this.rows.hashCode();
        return result;
    }
}

