/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.reports;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ReportParameter
implements DeepCloneable<ReportParameter>,
Serializable {
    private String name;
    private String limit;
    private String offset;
    private String select;
    private String criteria;
    private List<String> values = new LinkedList<String>();

    public ReportParameter(ReportParameter other) {
        ValueObjectUtils.checkNotNull(other);
        this.name = other.getName();
        this.limit = other.getLimit();
        this.offset = other.getOffset();
        this.select = other.getSelect();
        this.criteria = other.getCriteria();
        this.values = ValueObjectUtils.copyOf(other.getValues());
    }

    public ReportParameter() {
    }

    @XmlAttribute(required=true)
    @Schema(description="The parameter name.", required=true, example="someParameterName")
    public String getName() {
        return this.name;
    }

    public ReportParameter setName(String name) {
        this.name = name;
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public ReportParameter setSelect(String select) {
        this.select = select;
        return this;
    }

    public String getLimit() {
        return this.limit;
    }

    public ReportParameter setLimit(String limit) {
        this.limit = limit;
        return this;
    }

    public String getOffset() {
        return this.offset;
    }

    public ReportParameter setOffset(String offset) {
        this.offset = offset;
        return this;
    }

    public String getCriteria() {
        return this.criteria;
    }

    public ReportParameter setCriteria(String criteria) {
        this.criteria = criteria;
        return this;
    }

    @XmlElement(name="value")
    @ArraySchema(schema=@Schema(name="value", description="Specifies the list of values for this parameter.", example="someParameterValue"))
    public List<String> getValues() {
        return this.values;
    }

    public ReportParameter setValues(List<String> values) {
        this.values = values == null ? new LinkedList() : values;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportParameter that = (ReportParameter)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        if (this.select != null ? !this.select.equals(that.select) : that.select != null) {
            return false;
        }
        if (this.offset != null ? !this.offset.equals(that.offset) : that.offset != null) {
            return false;
        }
        if (this.criteria != null ? !this.criteria.equals(that.criteria) : that.criteria != null) {
            return false;
        }
        return new HashSet<String>(this.values).equals(new HashSet<String>(that.values));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.select != null ? this.select.hashCode() : 0);
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        result = 31 * result + (this.criteria != null ? this.criteria.hashCode() : 0);
        result = 31 * result + new HashSet<String>(this.values).hashCode();
        return result;
    }

    public String toString() {
        return "ReportParameter{name='" + this.name + '\'' + "limit='" + this.limit + '\'' + "offset='" + this.offset + '\'' + "select='" + this.select + '\'' + "criteria='" + this.criteria + '\'' + ", values=" + this.values + '}';
    }

    @Override
    public ReportParameter deepClone() {
        return new ReportParameter(this);
    }
}

