/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.reports;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.reports.ReportParameter;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ReportParameters
implements DeepCloneable<ReportParameters> {
    private List<ReportParameter> reportParameters;

    public ReportParameters() {
    }

    public ReportParameters(List<ReportParameter> reportParameters) {
        this.reportParameters = reportParameters;
    }

    public ReportParameters(ReportParameters other) {
        ValueObjectUtils.checkNotNull(other);
        this.reportParameters = ValueObjectUtils.copyOf(other.getReportParameters());
    }

    @XmlElement(name="reportParameter")
    @ArraySchema(schema=@Schema(name="reportParameter", description="The list of report parameters.", implementation=ReportParameter.class))
    public List<ReportParameter> getReportParameters() {
        return this.reportParameters;
    }

    public ReportParameters setReportParameters(List<ReportParameter> reportParameters) {
        this.reportParameters = reportParameters;
        return this;
    }

    @Schema(description="The raw parameters.", hidden=true)
    public Map<String, String[]> getRawParameters() {
        String SELECT = "_select";
        String LIMIT = "_limit";
        String OFFSET = "_offset";
        String CRITERIA = "_criteria";
        HashMap<String, String[]> rawParameters = new HashMap<String, String[]>();
        if (this.reportParameters != null) {
            for (ReportParameter currentParameter : this.reportParameters) {
                if (currentParameter.getValues().size() > 0) {
                    rawParameters.put(currentParameter.getName(), currentParameter.getValues().toArray(new String[currentParameter.getValues().size()]));
                }
                if (currentParameter.getSelect() != null) {
                    rawParameters.put(currentParameter.getName() + SELECT, new String[]{currentParameter.getSelect()});
                }
                if (currentParameter.getLimit() != null) {
                    rawParameters.put(currentParameter.getName() + LIMIT, new String[]{currentParameter.getLimit()});
                }
                if (currentParameter.getOffset() != null) {
                    rawParameters.put(currentParameter.getName() + OFFSET, new String[]{currentParameter.getOffset()});
                }
                if (currentParameter.getCriteria() == null) continue;
                rawParameters.put(currentParameter.getName() + CRITERIA, new String[]{currentParameter.getCriteria()});
            }
        }
        return rawParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportParameters that = (ReportParameters)o;
        return this.reportParameters != null ? this.reportParameters.equals(that.reportParameters) : that.reportParameters == null;
    }

    public int hashCode() {
        return this.reportParameters != null ? this.reportParameters.hashCode() : 0;
    }

    public String toString() {
        return "ReportParameters{reportParameters=" + this.reportParameters + '}';
    }

    @Override
    public ReportParameters deepClone() {
        return new ReportParameters(this);
    }
}

