/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.reports.inputcontrols;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="inputControlOption")
public class InputControlOption
implements Serializable,
DeepCloneable<InputControlOption> {
    private static final long serialVersionUID = 1L;
    private Boolean selected;
    private String label;
    private String value;

    public InputControlOption(String value, String label, Boolean selected) {
        this.label = label;
        this.value = value;
        this.selected = selected;
    }

    public InputControlOption() {
        this(null, null, false);
    }

    public InputControlOption(String value, String label) {
        this(value, label, false);
    }

    public InputControlOption(InputControlOption other) {
        ValueObjectUtils.checkNotNull(other);
        this.selected = other.isSelected();
        this.label = other.getLabel();
        this.value = other.getValue();
    }

    public boolean hasSelected() {
        return this.selected != null && this.selected != false;
    }

    public Boolean isSelected() {
        return this.selected;
    }

    public InputControlOption setSelected(Boolean selected) {
        this.selected = selected;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public InputControlOption setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public InputControlOption setValue(String value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputControlOption)) {
            return false;
        }
        InputControlOption that = (InputControlOption)o;
        if (this.selected != that.selected) {
            return false;
        }
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.selected != null ? this.selected.hashCode() : 0;
        result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "InputControlOption{selected=" + this.selected + ", label='" + this.label + '\'' + ", value='" + this.value + '\'' + '}';
    }

    @Override
    public InputControlOption deepClone() {
        return new InputControlOption(this);
    }
}

