/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.reports.inputcontrols;

import com.jaspersoft.jasperserver.dto.common.DeepCloneable;
import com.jaspersoft.jasperserver.dto.reports.inputcontrols.InputControlOption;
import com.jaspersoft.jasperserver.dto.utils.ValueObjectUtils;
import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class InputControlState
implements Serializable,
DeepCloneable<InputControlState> {
    private static final long serialVersionUID = 1L;
    private String uri;
    private String id;
    private String value;
    private String error;
    private String totalCount;
    private List<InputControlOption> options;

    public InputControlState() {
    }

    public InputControlState(InputControlState other) {
        ValueObjectUtils.checkNotNull(other);
        this.uri = other.getUri();
        this.id = other.getId();
        this.value = other.getValue();
        this.error = other.getError();
        this.totalCount = other.getTotalCount();
        this.options = ValueObjectUtils.copyOf(other.getOptions());
    }

    public String getId() {
        return this.id;
    }

    public InputControlState setId(String id) {
        this.id = id;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public InputControlState setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public InputControlState setValue(String value) {
        this.value = value;
        return this;
    }

    public String getError() {
        return this.error;
    }

    public InputControlState setError(String error) {
        this.error = error;
        return this;
    }

    public String getTotalCount() {
        return this.totalCount;
    }

    public InputControlState setTotalCount(String totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @XmlElementWrapper(name="options")
    @XmlElement(name="option")
    public List<InputControlOption> getOptions() {
        return this.options;
    }

    public InputControlState setOptions(List<InputControlOption> options) {
        this.options = options;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputControlState)) {
            return false;
        }
        InputControlState that = (InputControlState)o;
        if (this.uri != null ? !this.uri.equals(that.uri) : that.uri != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.totalCount != null ? !this.totalCount.equals(that.totalCount) : that.totalCount != null) {
            return false;
        }
        return this.options != null ? this.options.equals(that.options) : that.options == null;
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.totalCount != null ? this.totalCount.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "InputControlState{uri='" + this.uri + '\'' + ", id='" + this.id + '\'' + ", value='" + this.value + '\'' + ", error='" + this.error + '\'' + ", totalCount='" + this.totalCount + '\'' + ", options=" + this.options + '}';
    }

    @Override
    public InputControlState deepClone() {
        return new InputControlState(this);
    }
}

